/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.sql.Timestamp;
import java.util.Calendar;
import javax.inject.Inject;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetFilterTest {
    public static final String EXPENSE_REPORTS = "expense_reports";
    @Inject
    public DataSetManager dataSetManager;
    @Inject
    public DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        DataSet dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetManager.registerDataSet(dataSet);
        this.dataSetFormatter = new DataSetFormatter();
    }

    @Test
    public void testFilterByString() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("city", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(6);
        Assertions.assertDataSetValue(result, 0, 0, "1.00");
        Assertions.assertDataSetValue(result, 5, 0, "6.00");
    }

    @Test
    public void testFilterByNumber() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.between((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200))})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(5);
        Assertions.assertDataSetValue(result, 0, 0, "1.00");
        Assertions.assertDataSetValue(result, 1, 0, "6.00");
        Assertions.assertDataSetValue(result, 2, 0, "10.00");
        Assertions.assertDataSetValue(result, 3, 0, "17.00");
        Assertions.assertDataSetValue(result, 4, 0, "33.00");
    }

    @Test
    public void testFilterByDate() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(2015, 0, 0, 0, 0);
        Timestamp date = new Timestamp(c.getTime().getTime());
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("date", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)new Timestamp(date.getTime()))})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(15);
    }

    @Test
    public void testFilterUntilToday() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("date", new ColumnFilter[]{FilterFactory.timeFrame((String)"10second")})).buildLookup());
    }

    @Test
    public void testFilterMultiple() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(2015, 0, 0, 0, 0);
        Timestamp date = new Timestamp(c.getTime().getTime());
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("date", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)date)})).filter("amount", new ColumnFilter[]{FilterFactory.lowerOrEqualsTo((Comparable)Double.valueOf(120.35))})).filter("city", new ColumnFilter[]{FilterFactory.notEqualsTo((Comparable)((Object)"Barcelona"))})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(2);
        Assertions.assertDataSetValue(result, 0, 0, "9.00");
        Assertions.assertDataSetValue(result, 1, 0, "10.00");
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("city", new ColumnFilter[]{FilterFactory.notEqualsTo((Comparable)((Object)"Barcelona"))})).filter("amount", new ColumnFilter[]{FilterFactory.lowerOrEqualsTo((Comparable)Double.valueOf(120.35))})).filter("date", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)date)})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(2);
        Assertions.assertDataSetValue(result, 0, 0, "9.00");
        Assertions.assertDataSetValue(result, 1, 0, "10.00");
    }

    @Test
    public void testANDExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100)), FilterFactory.lowerThan((Comparable)Integer.valueOf(150))})})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertDataSetValue(result, 0, 0, "1.00");
    }

    @Test
    public void testNOTExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.NOT((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100))})})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(5);
        Assertions.assertDataSetValue(result, 0, 0, "9.00");
        Assertions.assertDataSetValue(result, 4, 0, "30.00");
    }

    @Test
    public void testORExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.NOT((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100))}), FilterFactory.greaterThan((Comparable)Integer.valueOf(1000))})})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(7);
        Assertions.assertDataSetValue(result, 0, 0, "2.00");
        Assertions.assertDataSetValue(result, 6, 0, "30.00");
    }

    @Test
    public void testCombinedExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"department", (Comparable)((Object)"Sales")), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.NOT((ColumnFilter[])new ColumnFilter[]{FilterFactory.lowerThan((Comparable)Integer.valueOf(300))}), FilterFactory.equalsTo((String)"city", (Comparable)((Object)"Madrid"))})})})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(7);
        Assertions.assertDataSetValue(result, 0, 0, "9.00");
        Assertions.assertDataSetValue(result, 6, 0, "28.00");
    }

    private void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

