/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.backend.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetDefJSONMarshallerTest {
    private static final String UTF_8 = "UTF-8";
    private static final String BEAN_DEF_PATH = "beanDataSetDef.dset";
    private static final String FILTER_DEF_PATH = "dataSetDefFilter.dset";
    @Inject
    DataSetManager dataSetManager;
    @Inject
    DataSetFormatter dataSetFormatter;
    @Inject
    DataSetDefRegistry dataSetDefRegistry;
    @Inject
    DataSetProviderRegistry dataSetProviderRegistry;
    @Inject
    DataSetDefJSONMarshaller dataSetDefJSONMarshaller;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testBean() throws Exception {
        BeanDataSetDef dataSetDef = new BeanDataSetDef();
        dataSetDef.setName("bean data set name");
        dataSetDef.setUUID("bean-test-uuid");
        dataSetDef.setProvider(DataSetProviderType.BEAN);
        dataSetDef.setCacheEnabled(false);
        dataSetDef.setCacheMaxRows(Integer.valueOf(100));
        dataSetDef.setPublic(true);
        dataSetDef.setPushEnabled(false);
        dataSetDef.setPushMaxSize(Integer.valueOf(10));
        dataSetDef.setRefreshAlways(false);
        dataSetDef.setRefreshTime("1second");
        dataSetDef.setGeneratorClass("org.dashbuilder.DataSetGenerator");
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("p1", "v1");
        parameterMap.put("p2", "v2");
        dataSetDef.setParamaterMap(parameterMap);
        String json = this.dataSetDefJSONMarshaller.toJsonString((DataSetDef)dataSetDef);
        String beanJSONContent = DataSetDefJSONMarshallerTest.getFileAsString(BEAN_DEF_PATH);
        this.assertDataSetDef(json, beanJSONContent);
    }

    @Test
    public void testFilters() throws Exception {
        BeanDataSetDef dataSetDef = new BeanDataSetDef();
        dataSetDef.setName("filter data set name");
        dataSetDef.setUUID("filter-test-uuid");
        dataSetDef.setProvider(DataSetProviderType.BEAN);
        dataSetDef.setCacheEnabled(false);
        dataSetDef.setCacheMaxRows(Integer.valueOf(100));
        dataSetDef.setPublic(true);
        dataSetDef.setPushEnabled(false);
        dataSetDef.setPushMaxSize(Integer.valueOf(10));
        dataSetDef.setRefreshAlways(false);
        dataSetDef.setRefreshTime("1second");
        dataSetDef.setGeneratorClass("org.dashbuilder.dataprovider.SalesPerYearDataSetGenerator");
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("multiplier", "1");
        dataSetDef.setParamaterMap(parameterMap);
        DataSetFilter filter = new DataSetFilter();
        String[] params = new String[]{"JANUARY"};
        CoreFunctionFilter columnFilter = new CoreFunctionFilter("month", CoreFunctionType.EQUALS_TO, Arrays.asList(params));
        filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        dataSetDef.setDataSetFilter(filter);
        String json = this.dataSetDefJSONMarshaller.toJsonString((DataSetDef)dataSetDef);
        String filteredDataSetDefJSONContent = DataSetDefJSONMarshallerTest.getFileAsString(FILTER_DEF_PATH);
        this.assertDataSetDef(json, filteredDataSetDefJSONContent);
    }

    private void assertDataSetDef(String def1, String def2) throws Exception {
        if (def1 == null && def2 != null) {
            Assert.assertTrue((String)"JSON string for Def1 is null and for Def2 is not null", (boolean)false);
        }
        if (def1 != null && def2 == null) {
            Assert.assertTrue((String)"JSON string for Def1 is not null and for Def2 is null", (boolean)false);
        }
        if (def1 == null) {
            Assert.assertTrue((String)"JSON string for both definitions is null", (boolean)false);
        }
        DataSetDef def1Object = this.dataSetDefJSONMarshaller.fromJson(def1);
        DataSetDef def2Object = this.dataSetDefJSONMarshaller.fromJson(def2);
        Assert.assertEquals((Object)def1Object, (Object)def2Object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getFileAsString(String file) throws Exception {
        InputStream mappingsFileUrl = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        StringWriter writer = null;
        String fileContent = null;
        try {
            writer = new StringWriter();
            IOUtils.copy((InputStream)mappingsFileUrl, (Writer)writer, (String)UTF_8);
            fileContent = writer.toString();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return fileContent.replaceAll("\n", "\r\n");
    }
}

