/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.dashbuilder.dataset.group.AggregateFunction;
import org.dashbuilder.dataset.group.AggregateFunctionManager;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class AggregateFunctionTest {
    @Inject
    AggregateFunctionManager aggregateFunctionManager;
    List listOfNumbers = Arrays.asList(1, 2, 3, 4, 5);
    List listOfStrings = Arrays.asList("A", "B", "C", "A", "B");

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testSumFunction() throws Exception {
        AggregateFunction sf = this.aggregateFunctionManager.getFunctionByType(AggregateFunctionType.SUM);
        double result = sf.aggregate(this.listOfNumbers);
        Assertions.assertThat((double)result).isEqualTo(15.0);
    }

    @Test
    public void testAvgFunction() throws Exception {
        AggregateFunction sf = this.aggregateFunctionManager.getFunctionByType(AggregateFunctionType.AVERAGE);
        double result = sf.aggregate(this.listOfNumbers);
        Assertions.assertThat((double)result).isEqualTo(3.0);
    }

    @Test
    public void testMaxFunction() throws Exception {
        AggregateFunction sf = this.aggregateFunctionManager.getFunctionByType(AggregateFunctionType.MAX);
        double result = sf.aggregate(this.listOfNumbers);
        Assertions.assertThat((double)result).isEqualTo(5.0);
    }

    @Test
    public void testMinFunction() throws Exception {
        AggregateFunction sf = this.aggregateFunctionManager.getFunctionByType(AggregateFunctionType.MIN);
        double result = sf.aggregate(this.listOfNumbers);
        Assertions.assertThat((double)result).isEqualTo(1.0);
    }

    @Test
    public void testCountFunction() throws Exception {
        AggregateFunction sf = this.aggregateFunctionManager.getFunctionByType(AggregateFunctionType.COUNT);
        double result = sf.aggregate(this.listOfStrings);
        Assertions.assertThat((double)result).isEqualTo(5.0);
    }

    @Test
    public void testDistinctFunction() throws Exception {
        AggregateFunction sf = this.aggregateFunctionManager.getFunctionByType(AggregateFunctionType.DISTINCT);
        double result = sf.aggregate(this.listOfStrings);
        Assertions.assertThat((double)result).isEqualTo(3.0);
    }
}

