/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.comparator;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.dashbuilder.comparator.ComparatorUtils;
import org.fest.assertions.api.Assertions;
import org.junit.Test;

public class ComparatorUtilsTest {
    Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ComparatorUtils.compare((Object)o1, (Object)o2, (int)-1);
        }
    };

    @Test
    public void testString() throws Exception {
        String[] stringArray = new String[]{"3", "4", "1"};
        List<String> stringList = Arrays.asList(stringArray);
        Collections.sort(stringList, this.comparator);
        Assertions.assertThat((Object)stringList.get(0)).isEqualTo((Object)"4");
        Assertions.assertThat((Object)stringList.get(1)).isEqualTo((Object)"3");
        Assertions.assertThat((Object)stringList.get(2)).isEqualTo((Object)"1");
    }

    @Test
    public void testLong() throws Exception {
        Long a = new Long(3L);
        Long b = new Long(2L);
        Long c = new Long(4L);
        Long[] longArray = new Long[]{a, b, c};
        List<Long> longList = Arrays.asList(longArray);
        Collections.sort(longList, this.comparator);
        Assertions.assertThat((Object)longList.get(0)).isEqualTo((Object)c);
        Assertions.assertThat((Object)longList.get(1)).isEqualTo((Object)a);
        Assertions.assertThat((Object)longList.get(2)).isEqualTo((Object)b);
    }

    @Test
    public void testBoolean() throws Exception {
        Boolean[] booleanArray = new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE};
        List<Boolean> booleanList = Arrays.asList(booleanArray);
        Collections.sort(booleanList, this.comparator);
        Assertions.assertThat((Object)booleanList.get(0)).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)booleanList.get(1)).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)booleanList.get(2)).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testCollection() throws Exception {
        List<String> collection1 = Arrays.asList("A");
        List<String> collection2 = Arrays.asList("B");
        int result = this.comparator.compare(collection1, collection2);
        Assertions.assertThat((int)result).isEqualTo(1);
    }
}

