/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.impl.DataSetImpl;

public class RawDataSet
implements Serializable {
    protected String[][] data;
    protected Class[] types;
    protected String[] columnIds;
    protected DataSetFormatter dataSetFormatter;
    public static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(String.class, Double.class, Integer.class, Date.class);

    public RawDataSet(String[] columnIds, Class[] types, String[][] data) {
        this(columnIds, types, data, new DataSetFormatter());
    }

    public RawDataSet(String[] columnIds, Class[] types, String[][] data, DataSetFormatter formatter) {
        this.columnIds = columnIds;
        this.types = types;
        this.data = data;
        this.dataSetFormatter = formatter;
        for (Class type : types) {
            if (SUPPORTED_TYPES.contains(type)) continue;
            throw new IllegalArgumentException("Type not supported: " + type);
        }
    }

    public String getRawValueAt(int x, int y) {
        if (x >= this.data.length) {
            throw new IndexOutOfBoundsException("Max row index allowed: " + (this.data.length - 1));
        }
        String[] row = this.data[x];
        if (y >= row.length) {
            throw new IndexOutOfBoundsException("Max column index allowed: " + (row.length - 1));
        }
        return row[y];
    }

    public Object parseValue(String rawValue, Class<?> type) throws ParseException {
        if (Date.class.isAssignableFrom(type)) {
            return this.dataSetFormatter.dateFormat.parse(rawValue);
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.dataSetFormatter.numberFormat.parse(rawValue).doubleValue();
        }
        return rawValue;
    }

    public DataSet toDataSet() throws ParseException {
        DataSetImpl dataSet = new DataSetImpl();
        for (int i = 0; i < this.columnIds.length; ++i) {
            dataSet.addColumn(this.columnIds[i], this.getColumnType(this.types[i]));
            for (int j = 0; j < this.data.length; ++j) {
                String[] row = this.data[j];
                Object value = this.parseValue(row[i], this.types[i]);
                dataSet.setValueAt(j, i, value);
            }
        }
        return dataSet;
    }

    public ColumnType getColumnType(Class<?> type) {
        if (Date.class.isAssignableFrom(type)) {
            return ColumnType.DATE;
        }
        if (Number.class.isAssignableFrom(type)) {
            return ColumnType.NUMBER;
        }
        return ColumnType.LABEL;
    }
}

