/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.inject.Inject;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetNestedGroupTest {
    public static final String EXPENSE_REPORTS = "expense_reports_dataset";
    @Inject
    DataSetManager dataSetManager;
    protected DataSet dataSet;
    protected DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        this.dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        this.dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetManager.registerDataSet(this.dataSet);
        this.dataSetFormatter = new DataSetFormatter();
    }

    @Test
    public void testGroupSelectionFilter() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.isGreaterThan((Comparable)Integer.valueOf(500))})).group("department")).select(new String[]{"Engineering"})).group("city")).select(new String[]{"Westford"})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertDataSetValue(result, 0, 0, "26.00");
    }

    @Test
    public void testNestedGroupFromMultipleSelection() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("department", "Department")).select(new String[]{"Services", "Engineering"})).group("city", "City")).count("Occurrences")).min("amount", "min")).max("amount", "max")).avg("amount", "average")).sum("amount", "total")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Barcelona", "6.00", "120.35", "1,100.10", "485.52", "2,913.14"}, {"Madrid", "2.00", "800.80", "911.11", "855.95", "1,711.91"}, {"Brno", "4.00", "159.01", "800.24", "364.86", "1,459.45"}, {"Westford", "5.00", "1.10", "600.34", "265.29", "1,326.43"}, {"Raleigh", "4.00", "209.55", "401.40", "284.38", "1,137.53"}, {"London", "3.00", "333.45", "868.45", "535.40", "1,606.20"}}, 0);
    }

    @Test
    public void testNestedGroupRequiresSelection() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("department", "Department")).group("city", "city")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Engineering"}, {"Services"}, {"Sales"}, {"Support"}, {"Management"}}, 0);
    }

    @Test
    public void testNoResultsSelection() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("employee")).select(new String[]{"Jerri Preble"})).group("department")).select(new String[]{"Engineering"})).group("city")).select(new String[]{"Westford"})).group("date")).fixed(DateIntervalType.MONTH)).sum("amount", "total")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"JANUARY", "0.00"}, {"FEBRUARY", "0.00"}, {"MARCH", "0.00"}, {"APRIL", "0.00"}, {"MAY", "0.00"}, {"JUNE", "0.00"}, {"JULY", "0.00"}, {"AUGUST", "0.00"}, {"SEPTEMBER", "0.00"}, {"OCTOBER", "0.00"}, {"NOVEMBER", "0.00"}, {"DECEMBER", "0.00"}}, 0);
    }

    @Test
    public void testThreeNestedLevels() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("department")).select(new String[]{"Services", "Engineering"})).group("city")).select(new String[]{"Madrid", "Barcelona"})).group("date")).fixed(DateIntervalType.MONTH)).sum("amount", "total")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"JANUARY", "0.00"}, {"FEBRUARY", "0.00"}, {"MARCH", "0.00"}, {"APRIL", "0.00"}, {"MAY", "0.00"}, {"JUNE", "911.11"}, {"JULY", "800.80"}, {"AUGUST", "152.25"}, {"SEPTEMBER", "300.00"}, {"OCTOBER", "340.34"}, {"NOVEMBER", "900.10"}, {"DECEMBER", "1,220.45"}}, 0);
    }

    private void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

