/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.inject.Inject;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetGroupTest {
    public static final String EXPENSE_REPORTS = "expense_reports_dataset";
    @Inject
    DataSetManager dataSetManager;
    protected DataSet dataSet;
    protected DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        this.dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        this.dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetManager.registerDataSet(this.dataSet);
        this.dataSetFormatter = new DataSetFormatter();
    }

    @Test
    public void testDataSetFunctions() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).count("#items")).min("amount")).max("amount")).avg("amount")).sum("amount")).distinct("city")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"50.00", "1.10", "1,100.10", "454.63", "22,731.26", "6.00"}}, 0);
    }

    @Test
    public void testGroupByLabelDynamic() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("department", "Department")).count("Occurrences")).min("amount", "min")).max("amount", "max")).avg("amount", "average")).sum("amount", "total")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Engineering", "19.00", "1.10", "1,100.10", "402.64", "7,650.16"}, {"Services", "5.00", "152.25", "911.11", "500.90", "2,504.50"}, {"Sales", "8.00", "75.75", "995.30", "401.69", "3,213.53"}, {"Support", "7.00", "300.01", "1,001.90", "477.94", "3,345.60"}, {"Management", "11.00", "43.03", "992.20", "547.04", "6,017.47"}}, 0);
    }

    @Test
    public void testGroupByDateDynamic() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("date", "Period", GroupStrategy.DYNAMIC, 10, "year")).count("Occurrences")).sum("amount", "totalAmount")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"2012", "13.00", "6,126.13"}, {"2013", "11.00", "5,252.96"}, {"2014", "11.00", "4,015.48"}, {"2015", "15.00", "7,336.69"}}, 0);
    }

    @Test
    public void testGroupByMonth() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("date", "Period")).fixed(DateIntervalType.MONTH)).count("Occurrences")).sum("amount", "totalAmount")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"JANUARY", "3.00", "2,324.20"}, {"FEBRUARY", "6.00", "2,885.57"}, {"MARCH", "5.00", "1,012.55"}, {"APRIL", "3.00", "1,061.06"}, {"MAY", "5.00", "2,503.34"}, {"JUNE", "9.00", "4,113.87"}, {"JULY", "4.00", "2,354.04"}, {"AUGUST", "2.00", "452.25"}, {"SEPTEMBER", "3.00", "693.35"}, {"OCTOBER", "3.00", "1,366.40"}, {"NOVEMBER", "3.00", "1,443.75"}, {"DECEMBER", "4.00", "2,520.88"}}, 0);
    }

    @Test
    public void testGroupByMonthFirstMonth() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("date", "Period")).fixed(DateIntervalType.MONTH)).firstMonth(Month.NOVEMBER)).count("Occurrences")).sum("amount", "totalAmount")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"NOVEMBER", "3.00", "1,443.75"}, {"DECEMBER", "4.00", "2,520.88"}, {"JANUARY", "3.00", "2,324.20"}, {"FEBRUARY", "6.00", "2,885.57"}, {"MARCH", "5.00", "1,012.55"}, {"APRIL", "3.00", "1,061.06"}, {"MAY", "5.00", "2,503.34"}, {"JUNE", "9.00", "4,113.87"}, {"JULY", "4.00", "2,354.04"}, {"AUGUST", "2.00", "452.25"}, {"SEPTEMBER", "3.00", "693.35"}, {"OCTOBER", "3.00", "1,366.40"}}, 0);
    }

    @Test
    public void testGroupByMonthReverse() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("date", "Period")).fixed(DateIntervalType.MONTH)).desc()).count("Occurrences")).sum("amount", "totalAmount")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"DECEMBER", "4.00", "2,520.88"}, {"NOVEMBER", "3.00", "1,443.75"}, {"OCTOBER", "3.00", "1,366.40"}, {"SEPTEMBER", "3.00", "693.35"}, {"AUGUST", "2.00", "452.25"}, {"JULY", "4.00", "2,354.04"}, {"JUNE", "9.00", "4,113.87"}, {"MAY", "5.00", "2,503.34"}, {"APRIL", "3.00", "1,061.06"}, {"MARCH", "5.00", "1,012.55"}, {"FEBRUARY", "6.00", "2,885.57"}, {"JANUARY", "3.00", "2,324.20"}}, 0);
    }

    @Test
    public void testGroupByMonthFirstMonthReverse() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("date", "Period")).fixed(DateIntervalType.MONTH)).desc()).firstMonth(Month.MARCH)).count("Occurrences")).sum("amount", "totalAmount")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"MARCH", "5.00", "1,012.55"}, {"FEBRUARY", "6.00", "2,885.57"}, {"JANUARY", "3.00", "2,324.20"}, {"DECEMBER", "4.00", "2,520.88"}, {"NOVEMBER", "3.00", "1,443.75"}, {"OCTOBER", "3.00", "1,366.40"}, {"SEPTEMBER", "3.00", "693.35"}, {"AUGUST", "2.00", "452.25"}, {"JULY", "4.00", "2,354.04"}, {"JUNE", "9.00", "4,113.87"}, {"MAY", "5.00", "2,503.34"}, {"APRIL", "3.00", "1,061.06"}}, 0);
    }

    @Test
    public void testFirstDayOfWeekOk() throws Exception {
        ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().group("date")).fixed(DateIntervalType.DAY_OF_WEEK)).firstDay(DayOfWeek.MONDAY);
    }

    @Test
    public void testFirstDayOfWeekNok() throws Exception {
        try {
            ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().group("date")).fixed(DateIntervalType.QUARTER)).firstDay(DayOfWeek.MONDAY);
            org.fest.assertions.api.Assertions.fail((String)"firstDayOfWeek required a DAY_OF_WEEK fixed domain.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testFirstDayOfMonthOk() throws Exception {
        ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().group("date")).fixed(DateIntervalType.MONTH)).firstMonth(Month.APRIL);
    }

    @Test
    public void testFirstDayOfMonthNok() throws Exception {
        try {
            ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().group("date")).fixed(DateIntervalType.QUARTER)).firstMonth(Month.APRIL);
            org.fest.assertions.api.Assertions.fail((String)"firstDayOfWeek required a DAY_OF_WEEK fixed domain.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupByWeek() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("date", "Period")).fixed(DateIntervalType.DAY_OF_WEEK)).firstDay(DayOfWeek.MONDAY)).count("Occurrences")).sum("amount", "totalAmount")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"MONDAY", "10.00", "3,904.17"}, {"TUESDAY", "8.00", "4,525.69"}, {"WEDNESDAY", "7.00", "4,303.14"}, {"THURSDAY", "4.00", "1,021.95"}, {"FRIDAY", "8.00", "3,099.08"}, {"SATURDAY", "5.00", "2,012.05"}, {"SUNDAY", "8.00", "3,865.18"}}, 0);
    }

    @Test
    public void testGroupByQuarter() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDSLookupBuilder().dataset(EXPENSE_REPORTS)).group("date", "Period")).fixed(DateIntervalType.QUARTER)).count("Occurrences")).sum("amount", "totalAmount")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Q1", "14.00", "6,222.32"}, {"Q2", "17.00", "7,678.27"}, {"Q3", "9.00", "3,499.64"}, {"Q4", "10.00", "5,331.03"}}, 0);
    }

    private void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

