/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;

public class DataSetFormatter {
    protected String numberPattern = "#,##0.00";
    protected String datePattern = "MM/dd/yy HH:mm";
    protected transient DateFormat dateFormat;
    protected transient DecimalFormat numberFormat;

    public DataSetFormatter() {
        DecimalFormatSymbols numberSymbols = new DecimalFormatSymbols();
        numberSymbols.setGroupingSeparator(this.getNumberGroupSeparator());
        numberSymbols.setDecimalSeparator(this.getNumberDecimalSeparator());
        this.numberFormat = new DecimalFormat(this.numberPattern, numberSymbols);
        this.dateFormat = new SimpleDateFormat(this.datePattern);
    }

    public char getNumberGroupSeparator() {
        if (this.numberPattern.length() < 2) {
            return ',';
        }
        return this.numberPattern.charAt(1);
    }

    public char getNumberDecimalSeparator() {
        if (this.numberPattern.length() < 6) {
            return '.';
        }
        return this.numberPattern.charAt(5);
    }

    public String formatValueAt(DataSet dataSet, int row, int col) {
        Object val = dataSet.getValueAt(row, col);
        DataColumn column = dataSet.getColumnByIndex(col);
        if (ColumnType.DATE.equals((Object)column.getColumnType())) {
            return this.dateFormat.format(val);
        }
        if (ColumnType.NUMBER.equals((Object)column.getColumnType())) {
            return this.numberFormat.format(val);
        }
        return val.toString();
    }

    public String formatDataSet(DataSet dataSet, String rowBegin, String rowEnd, String rowSep, String columnBegin, String columnEnd, String columnSep) {
        StringBuilder sb = new StringBuilder();
        List columns = dataSet.getColumns();
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            if (i > 0) {
                sb.append(rowSep);
            }
            sb.append(rowBegin);
            for (int j = 0; j < columns.size(); ++j) {
                if (j > 0) {
                    sb.append(columnSep);
                }
                sb.append(columnBegin);
                sb.append(this.formatValueAt(dataSet, i, j));
                sb.append(columnEnd);
            }
            sb.append(rowEnd);
        }
        return sb.toString();
    }
}

