/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;

public class Assertions {
    public static void assertDataSetValue(DataSet dataSet, int x, int y, String expected) {
        Assertions.assertDataSetValue(dataSet, new DataSetFormatter(), x, y, expected);
    }

    public static void assertDataSetValue(DataSet dataSet, DataSetFormatter formatter, int x, int y, String expected) {
        DataColumn col = dataSet.getColumnByIndex(y);
        String displayedValue = formatter.formatValueAt(dataSet, x, y);
        if (!displayedValue.equals(expected)) {
            org.fest.assertions.api.Assertions.fail((String)("Data set value [" + x + "," + y + "] is different. " + "Column=\"" + col.getId() + "\" " + "Actual=\"" + displayedValue + "\" Expected=\"" + expected + "\""));
        }
    }

    public static void assertDataSetValues(DataSet dataSet, String[][] expected, int index) {
        Assertions.assertDataSetValues(dataSet, new DataSetFormatter(), expected, index);
    }

    public static void assertDataSetValues(DataSet dataSet, DataSetFormatter formatter, String[][] expected, int index) {
        org.fest.assertions.api.Assertions.assertThat((int)dataSet.getRowCount()).isGreaterThan(index);
        for (int i = index; i < expected.length; ++i) {
            String[] row = expected[i];
            for (int j = 0; j < row.length; ++j) {
                String displayedValue;
                DataColumn col = dataSet.getColumnByIndex(j);
                String expectedValue = row[j];
                if (expectedValue == null || (displayedValue = formatter.formatValueAt(dataSet, i, j)).equals(expectedValue)) continue;
                org.fest.assertions.api.Assertions.fail((String)("Data set value [" + i + "," + j + "] is different. " + "Column=\"" + col.getId() + "\" " + "Actual=\"" + displayedValue + "\" Expected=\"" + expectedValue + "\""));
            }
        }
    }
}

