/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.navigation.layout.LayoutRecursionIssue;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;

@Dependent
public class PerspectiveWidget
implements IsWidget {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    String perspectiveId;

    @Inject
    public PerspectiveWidget(View view, PerspectivePluginManager perspectivePluginManager) {
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void showPerspective(String id) {
        this.perspectiveId = id;
        if (id == null || !this.perspectivePluginManager.existsPerspectivePlugin(id)) {
            this.view.notFoundError();
        } else {
            this.perspectivePluginManager.buildPerspectiveWidget(id, this.view::showContent, this::onDeadlock);
        }
    }

    private void onDeadlock(LayoutRecursionIssue issue) {
        this.view.infiniteRecursionError();
    }

    private void refreshPerspective(Plugin plugin) {
        if (this.perspectiveId != null && this.perspectiveId.equals(plugin.getName())) {
            this.showPerspective(this.perspectiveId);
        }
    }

    public void onPlugInSaved(@Observes PluginSaved event) {
        this.refreshPerspective(event.getPlugin());
    }

    public void onPlugInDeleted(@Observes PluginDeleted event) {
        this.refreshPerspective(event.getPlugin());
    }

    public static interface View
    extends UberView<PerspectiveWidget> {
        public void showContent(IsWidget var1);

        public void notFoundError();

        public void infiniteRecursionError();
    }
}

