/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.explorer;

import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.navigation.event.PerspectivePluginsChangedEvent;
import org.jboss.errai.common.client.api.IsElement;
import org.uberfire.backend.events.AuthorizationPolicySavedEvent;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
@WorkbenchScreen(identifier="NavigationExplorerScreen")
public class NavigationExplorerScreen {
    public static final String SCREEN_ID = "NavigationExplorerScreen";
    NavigationManager navigationManager;
    NavTreeEditor navTreeEditor;
    ContentManagerI18n i18n;
    Event<NotificationEvent> workbenchNotification;

    public NavigationExplorerScreen() {
    }

    @Inject
    public NavigationExplorerScreen(NavigationManager navigationManager, NavTreeEditor navTreeEditor, ContentManagerI18n i18n, Event<NotificationEvent> workbenchNotification) {
        this.navigationManager = navigationManager;
        this.navTreeEditor = navTreeEditor;
        this.i18n = i18n;
        this.workbenchNotification = workbenchNotification;
    }

    @PostConstruct
    void init() {
        this.navTreeEditor.setOnSaveCommand(this::onNavTreeSaved);
        this.navTreeEditor.getSettings().setLiteralPerspective(this.i18n.capitalizeFirst(this.i18n.getPerspectiveResourceName()));
        this.navTreeEditor.getSettings().setGotoPerspectiveEnabled(true);
        if (this.navTreeEditor.getNavTree() == null && this.navigationManager.getNavTree() != null) {
            this.navTreeEditor.edit(this.navigationManager.getNavTree());
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.i18n.getContentExplorerNavigation();
    }

    @WorkbenchPartView
    public IsElement getView() {
        return this.navTreeEditor;
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        menusConsumer.accept(((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.i18n.getContentExplorerNew()).respondsWith(this::createNewNavigationTree)).endMenu()).build());
    }

    public NavTreeEditor getNavTreeEditor() {
        return this.navTreeEditor;
    }

    public void createNewNavigationTree() {
        this.navTreeEditor.newTree();
    }

    void onNavTreeLoaded(@Observes NavTreeLoadedEvent event) {
        NavTree navTree = event.getNavTree();
        if (navTree != null) {
            this.navTreeEditor.edit(navTree);
        }
    }

    void onPerspectivesChanged(@Observes PerspectivePluginsChangedEvent event) {
        NavTree navTree = this.navigationManager.getNavTree();
        if (navTree != null) {
            this.navTreeEditor.edit(navTree);
        }
    }

    public void onNavTreeChanged(@Observes NavTreeChangedEvent event) {
        NavTree navTree = event.getNavTree();
        if (navTree != null) {
            this.navigationManager.update(navTree);
            this.navTreeEditor.edit(navTree);
        }
    }

    void onNavTreeSaved() {
        this.workbenchNotification.fire((Object)new NotificationEvent(this.i18n.getContentManagerNavigationChanged(), NotificationEvent.NotificationType.SUCCESS));
    }

    void onAuthzPolicyChanged(@Observes AuthorizationPolicySavedEvent event) {
        NavTree navTree = this.navigationManager.getNavTree();
        if (navTree != null) {
            this.navTreeEditor.edit(navTree);
        }
    }
}

