/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer.export.wizard.widget;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLCollection;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLTableCellElement;
import elemental2.dom.HTMLTableElement;
import elemental2.dom.HTMLTableRowElement;
import elemental2.dom.HTMLTableSectionElement;
import elemental2.dom.Node;
import java.util.Arrays;
import java.util.List;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.widget.AssetsTableAbstractPresenter;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.widget.AssetsTableView;
import org.dashbuilder.client.cms.screen.util.DomFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AssetsTableViewTest {
    @Mock
    DomFactory domFactory;
    @Mock
    HTMLTableRowElement assetsTableHeaderRow;
    @Mock
    HTMLInputElement searchAssets;
    @Mock
    HTMLInputElement selectAllAssets;
    @InjectMocks
    AssetsTableView assetsTableView;
    private MockAssetsTablePresenter presenter;

    @Before
    public void prepare() {
        this.presenter = new MockAssetsTablePresenter();
        Mockito.when((Object)this.domFactory.tableCell()).thenReturn((Object)new HTMLTableCellElement());
        Mockito.when((Object)this.domFactory.input()).thenReturn((Object)new HTMLInputElement());
        Mockito.when((Object)this.domFactory.tableRow()).thenReturn((Object)new HTMLTableRowElement());
        Mockito.when((Object)this.domFactory.element((String)ArgumentMatchers.any())).thenReturn((Object)new HTMLElement());
        this.assetsTableView.assetsTable = this.buildHTMLTable();
        this.assetsTableView.init((AssetsTableView.Presenter)this.presenter);
        this.presenter.view = this.assetsTableView;
    }

    @Test
    public void testTableRowsCreated() {
        List<String> assets = Arrays.asList("asset1", "asset2");
        this.presenter.setData(assets);
        HTMLTableSectionElement assetsTable = (HTMLTableSectionElement)this.assetsTableView.assetsTable.tBodies.getAt(0);
        ((HTMLTableSectionElement)Mockito.verify((Object)assetsTable, (VerificationMode)Mockito.times((int)assets.size()))).appendChild((Node)ArgumentMatchers.any());
    }

    @Test
    public void testFilterTable() {
        HTMLInputElement filter = this.assetsTableView.searchAssets;
        HTMLTableElement table = this.assetsTableView.assetsTable;
        HTMLCollection rows = (HTMLCollection)Mockito.mock(HTMLCollection.class);
        HTMLTableRowElement[] actualRows = new HTMLTableRowElement[]{(HTMLTableRowElement)Mockito.mock(HTMLTableRowElement.class), (HTMLTableRowElement)Mockito.mock(HTMLTableRowElement.class)};
        HTMLCollection firstRowCells = (HTMLCollection)Mockito.mock(HTMLCollection.class);
        HTMLCollection secondRowCells = (HTMLCollection)Mockito.mock(HTMLCollection.class);
        HTMLTableCellElement tableCellElement1 = (HTMLTableCellElement)Mockito.mock(HTMLTableCellElement.class);
        HTMLTableCellElement tableCellElement2 = (HTMLTableCellElement)Mockito.mock(HTMLTableCellElement.class);
        tableCellElement1.textContent = "Abc";
        tableCellElement2.textContent = "dEfx";
        Mockito.when((Object)firstRowCells.getAt(0)).thenReturn((Object)tableCellElement1);
        Mockito.when((Object)firstRowCells.getAt(1)).thenReturn((Object)tableCellElement2);
        HTMLTableCellElement tableCellElement3 = (HTMLTableCellElement)Mockito.mock(HTMLTableCellElement.class);
        HTMLTableCellElement tableCellElement4 = (HTMLTableCellElement)Mockito.mock(HTMLTableCellElement.class);
        tableCellElement3.textContent = "gHi";
        tableCellElement4.textContent = "jKlX";
        Mockito.when((Object)secondRowCells.getAt(0)).thenReturn((Object)tableCellElement3);
        Mockito.when((Object)secondRowCells.getAt(1)).thenReturn((Object)tableCellElement4);
        actualRows[0].cells = firstRowCells;
        actualRows[1].cells = secondRowCells;
        Mockito.when((Object)actualRows[0].cells.getLength()).thenReturn((Object)2);
        Mockito.when((Object)actualRows[1].cells.getLength()).thenReturn((Object)2);
        for (int i = 0; i < actualRows.length; ++i) {
            Mockito.when((Object)rows.getAt(i)).thenReturn((Object)actualRows[i]);
        }
        Mockito.when((Object)rows.getLength()).thenReturn((Object)actualRows.length);
        ((HTMLTableSectionElement)table.tBodies.getAt((int)0)).rows = rows;
        filter.value = "abC";
        this.assetsTableView.filterTable();
        Assert.assertTrue((boolean)actualRows[1].hidden);
        Assert.assertFalse((boolean)actualRows[0].hidden);
        filter.value = "jkL";
        this.assetsTableView.filterTable();
        Assert.assertTrue((boolean)actualRows[0].hidden);
        Assert.assertFalse((boolean)actualRows[1].hidden);
        filter.value = "X";
        this.assetsTableView.filterTable();
        Assert.assertFalse((boolean)actualRows[0].hidden);
        Assert.assertFalse((boolean)actualRows[1].hidden);
        filter.value = "z";
        this.assetsTableView.filterTable();
        Assert.assertTrue((boolean)actualRows[0].hidden);
        Assert.assertTrue((boolean)actualRows[1].hidden);
    }

    private HTMLTableElement buildHTMLTable() {
        HTMLTableElement table = new HTMLTableElement();
        HTMLCollection tableBodies = (HTMLCollection)Mockito.mock(HTMLCollection.class);
        HTMLTableSectionElement tableBody = (HTMLTableSectionElement)Mockito.mock(HTMLTableSectionElement.class);
        table.tBodies = tableBodies;
        Mockito.when((Object)tableBodies.getAt(0)).thenReturn((Object)tableBody);
        return table;
    }

    class MockAssetsTablePresenter
    extends AssetsTableAbstractPresenter<String> {
        MockAssetsTablePresenter() {
        }

        public String[] getHeaders() {
            return new String[]{"test"};
        }

        public String[] toRow(String t) {
            return new String[]{t};
        }
    }
}

