/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.client.cms.widget.NewPerspectivePopUpView;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.exception.PluginAlreadyExists;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@ApplicationScoped
public class NewPerspectivePopUp
implements IsElement {
    private Caller<PerspectiveServices> perspectiveServices;
    private PlaceManager placeManager;
    private PluginNameValidator pluginNameValidator;
    private NewPerspectivePopUpView view;

    protected NewPerspectivePopUp() {
    }

    @Inject
    public NewPerspectivePopUp(NewPerspectivePopUpView view, Caller<PerspectiveServices> perspectiveServices, PluginNameValidator pluginNameValidator, PlaceManager placeManager) {
        this.view = view;
        this.perspectiveServices = perspectiveServices;
        this.pluginNameValidator = pluginNameValidator;
        this.placeManager = placeManager;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    protected PlaceRequest getPathPlaceRequest(Plugin response) {
        return new PathPlaceRequest(response.getPath()).addParameter("name", response.getName());
    }

    public void show() {
        this.view.show();
    }

    public void hide() {
        this.view.hide();
    }

    public void onOK() {
        final String layoutName = this.view.getName();
        final LayoutTemplate.Style layoutStyle = LayoutTemplate.Style.valueOf((String)this.view.getStyle());
        this.pluginNameValidator.validate(layoutName + ".plugin", (ValidatorCallback)new ValidatorWithReasonCallback(){

            public void onFailure(String reason) {
                if (ValidationErrorReason.EMPTY_NAME.name().equals(reason)) {
                    NewPerspectivePopUp.this.view.errorEmptyName();
                } else if (ValidationErrorReason.DUPLICATED_NAME.name().equals(reason)) {
                    NewPerspectivePopUp.this.view.errorDuplicatedName();
                } else {
                    NewPerspectivePopUp.this.view.errorInvalidName();
                }
            }

            public void onSuccess() {
                ((PerspectiveServices)NewPerspectivePopUp.this.perspectiveServices.call(response -> {
                    NewPerspectivePopUp.this.placeManager.goTo(NewPerspectivePopUp.this.getPathPlaceRequest((Plugin)response));
                    NewPerspectivePopUp.this.hide();
                }, (message, throwable) -> {
                    if (throwable instanceof PluginAlreadyExists) {
                        NewPerspectivePopUp.this.view.errorDuplicatedName();
                    } else {
                        NewPerspectivePopUp.this.view.errorInvalidName();
                    }
                    return false;
                })).createNewPerspective(layoutName, layoutStyle);
            }

            public void onFailure() {
                NewPerspectivePopUp.this.view.errorInvalidName();
            }
        });
    }

    public void onCancel() {
        this.hide();
    }

    public static interface View
    extends UberElement<NewPerspectivePopUp> {
        public void show();

        public void hide();

        public String getName();

        public String getStyle();

        public void errorEmptyName();

        public void errorInvalidName();

        public void errorDuplicatedName();
    }
}

