/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer.export.wizard;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.ExportSummaryWizardPage;
import org.dashbuilder.client.cms.screen.util.DomFactory;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.client.views.pfly.widgets.HelpIcon;
import org.uberfire.workbench.events.NotificationEvent;

@Templated
@ApplicationScoped
public class ExportSummaryWizardPageView
implements ExportSummaryWizardPage.View {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportSummaryWizardPageView.class);
    ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    @Inject
    @DataField
    HTMLDivElement exportWizardSummary;
    @Inject
    @DataField
    @Named(value="span")
    HTMLElement datasetsInformation;
    @Inject
    @DataField
    @Named(value="span")
    HTMLElement pagesInformation;
    @Inject
    @DataField
    HTMLAnchorElement datasetsInfoAnchor;
    @Inject
    @DataField
    HTMLAnchorElement pagesInfoAnchor;
    @Inject
    @DataField
    HTMLButtonElement downloadExport;
    @Inject
    @DataField
    HTMLButtonElement openExport;
    @Inject
    @DataField
    HTMLDivElement actionsContainer;
    @Inject
    @DataField
    @Named(value="h1")
    HTMLHeadingElement exportHeading;
    @Inject
    @DataField
    @Named(value="span")
    HTMLElement iconSpan;
    @Inject
    @DataField
    HTMLDivElement alertContainer;
    @Inject
    @DataField
    HTMLDivElement navigationSummaryContainer;
    @Inject
    DomFactory domFactory;
    @Inject
    Elemental2DomUtil elementalUtil;
    @Inject
    private Event<NotificationEvent> wbNotification;
    private ExportSummaryWizardPage presenter;
    private HelpIcon openHelp;

    public void init(ExportSummaryWizardPage presenter) {
        this.presenter = presenter;
        this.alertContainer.hidden = true;
        this.openHelp = new HelpIcon();
        this.openHelp.setHelpContent(this.i18n.openHelpText());
        this.openHelp.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.SUPER);
        this.elementalUtil.appendWidgetToElement((HTMLElement)this.actionsContainer, (Widget)this.openHelp);
        HelpIcon navigationhelp = new HelpIcon();
        navigationhelp.setHelpContent(this.i18n.navigationHelpText());
        this.elementalUtil.appendWidgetToElement((HTMLElement)this.navigationSummaryContainer, (Widget)navigationhelp);
    }

    public HTMLElement getElement() {
        return this.exportWizardSummary;
    }

    @EventHandler(value={"downloadExport"})
    public void downloadAction(ClickEvent click) {
        this.presenter.confirmDownload();
    }

    @EventHandler(value={"openExport"})
    public void openAction(ClickEvent click) {
        this.presenter.openExport();
    }

    @EventHandler(value={"datasetsInfoAnchor"})
    public void datasetsInfoAnchorClicked(ClickEvent click) {
        this.presenter.goToDataSetsPage();
    }

    @EventHandler(value={"pagesInfoAnchor"})
    public void pagesInfoAnchorClicked(ClickEvent click) {
        this.presenter.goToPagesPage();
    }

    @Override
    public void success(DataTransferExportModel dataTransferExportModel) {
        this.successState();
        this.showSummary(dataTransferExportModel);
    }

    @Override
    public void validationErrors(DataTransferExportModel dataTransferExportModel, Map<String, List<String>> pageDependencies) {
        this.errorState();
        Element errorHeader = this.domFactory.element("strong");
        errorHeader.textContent = this.i18n.missingDependencies();
        this.alertContainer.appendChild((Node)errorHeader);
        Element pageList = this.domFactory.element("ul");
        pageDependencies.forEach((page, ds) -> {
            Element li = this.domFactory.listItem(this.i18n.pageMissingDataSets((String)page));
            li.appendChild((Node)this.pageMissingDataSetsList((List<String>)ds));
            pageList.appendChild((Node)li);
        });
        this.alertContainer.appendChild((Node)pageList);
        this.showSummary(dataTransferExportModel);
    }

    @Override
    public void exportError(DataTransferExportModel dataTransferExportModel, String warningMessage) {
        this.errorState();
        this.alertContainer.textContent = warningMessage;
        this.showSummary(dataTransferExportModel);
    }

    private void showSummary(DataTransferExportModel dataTransferExportModel) {
        this.pagesInformation.textContent = this.checkPlural(dataTransferExportModel.getPages().size(), this.i18n.pageLabel(), this.i18n.pagesLabel());
        this.datasetsInformation.textContent = this.checkPlural(dataTransferExportModel.getDatasetDefinitions().size(), this.i18n.datasetLabel(), this.i18n.datasetsLabel());
    }

    private String checkPlural(int size, String text, String pluralText) {
        String result = size + " ";
        return size == 1 ? result + text : result + pluralText;
    }

    private Element pageMissingDataSetsList(List<String> datasets) {
        Element list = this.domFactory.element("ul");
        datasets.stream().map(this.domFactory::listItem).forEach(arg_0 -> ((Element)list).appendChild(arg_0));
        return list;
    }

    @Override
    public void emptyState() {
        this.state("pficon-running", "", true, true);
        this.pagesInformation.textContent = "";
        this.datasetsInformation.textContent = "";
    }

    @Override
    public void validationError(Throwable throwable) {
        LOGGER.error(throwable.getMessage(), throwable);
        this.wbNotification.fire((Object)new NotificationEvent(this.i18n.validationError(), NotificationEvent.NotificationType.ERROR));
    }

    @Override
    public void showOpenExport(boolean externalServerAvailable) {
        this.openExport.style.visibility = externalServerAvailable ? "visible" : "hidden";
        this.openHelp.setVisible(externalServerAvailable);
    }

    private void errorState() {
        this.state("pficon pficon-error-circle-o", this.i18n.exportWizardHeadingError(), false, true);
        this.alertContainer.innerHTML = "";
    }

    private void successState() {
        this.state("pficon pficon-ok", this.i18n.exportWizardHeadingSuccess(), true, false);
    }

    private void state(String iconSpanClass, String headingText, boolean hideAlert, boolean hideDownload) {
        this.iconSpan.className = iconSpanClass;
        this.exportHeading.textContent = headingText;
        this.alertContainer.hidden = hideAlert;
        this.downloadExport.disabled = hideDownload;
        this.openExport.disabled = hideDownload;
    }
}

