/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLParagraphElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.screen.transfer.DataTransferPopUp;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

@Templated
@Dependent
public class DataTransferPopUpView
implements DataTransferPopUp.View,
IsElement {
    private BaseModal modal;
    private ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    private HTMLDivElement root;
    private HTMLDivElement body;
    private HTMLParagraphElement filesImportedMessage;
    private HTMLUListElement filesImportedList;
    private Elemental2DomUtil elem2Dom;

    public DataTransferPopUpView() {
    }

    @Inject
    public DataTransferPopUpView(@DataField HTMLDivElement root, @DataField HTMLDivElement body, @DataField HTMLParagraphElement filesImportedMessage, @DataField HTMLUListElement filesImportedList, Elemental2DomUtil elem2Dom) {
        this.root = root;
        this.body = body;
        this.filesImportedMessage = filesImportedMessage;
        this.filesImportedList = filesImportedList;
        this.elem2Dom = elem2Dom;
    }

    public void init(DataTransferPopUp presenter) {
        this.modal = new CommonModalBuilder().addHeader(this.i18n.dataTransferPopUpViewTitle()).addBody((HTMLElement)this.body).build();
    }

    public HTMLElement getElement() {
        return this.root;
    }

    @Override
    public void show(List<String> filesImported) {
        this.modal.setTitle(this.i18n.dataTransferPopUpViewTitle());
        this.elem2Dom.removeAllElementChildren((Node)this.filesImportedList);
        int size = filesImported.size();
        if (size == 0) {
            this.filesImportedMessage.textContent = this.i18n.importResultMessageNoData();
        } else {
            this.filesImportedMessage.textContent = this.i18n.importResultMessageOK(size);
            filesImported.forEach(fileImported -> {
                Element element = DOM.createElement((String)"li");
                element.setClassName("list-group-item");
                element.setInnerText(fileImported);
                this.filesImportedList.appendChild((Node)Js.cast((Object)element));
            });
        }
        this.modal.show();
    }
}

