/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.explorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.cms.screen.explorer.NavigationExplorerScreen;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditorSettings;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.event.PerspectivePluginsChangedEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NavigationExplorerScreenTest {
    @Mock
    NavigationManager navigationManager;
    @Mock
    NavTreeEditor navTreeEditor;
    @Mock
    NavItemEditorSettings navItemEditorSettings;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    ContentManagerI18n i18n;
    @Mock
    NavTree navTree;
    NavigationExplorerScreen navigationExplorerScreen;

    @Before
    public void setUp() {
        Mockito.when((Object)this.navTreeEditor.getSettings()).thenReturn((Object)this.navItemEditorSettings);
        this.navigationExplorerScreen = new NavigationExplorerScreen(this.navigationManager, this.navTreeEditor, this.i18n, this.notificationEvent);
    }

    @Test
    public void testInitTreeAlreadySet() {
        Mockito.when((Object)this.navigationManager.getNavTree()).thenReturn((Object)this.navTree);
        this.navigationExplorerScreen.init();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).edit(this.navTree);
    }

    @Test
    public void testOnNavTreeLoaded() {
        this.navigationExplorerScreen.init();
        this.navigationExplorerScreen.onNavTreeLoaded(new NavTreeLoadedEvent(this.navTree));
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).edit(this.navTree);
    }

    @Test
    public void testOnPerspectivesChanged() {
        this.navigationExplorerScreen.init();
        Mockito.when((Object)this.navigationManager.getNavTree()).thenReturn((Object)this.navTree);
        this.navigationExplorerScreen.onPerspectivesChanged(new PerspectivePluginsChangedEvent());
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.times((int)1))).edit((NavTree)Mockito.any(NavTree.class));
    }

    @Test
    public void testOnPerspectivesChangedWithNullNavTree() {
        this.navigationExplorerScreen.init();
        this.navigationExplorerScreen.onPerspectivesChanged(new PerspectivePluginsChangedEvent());
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.times((int)0))).edit((NavTree)Mockito.any(NavTree.class));
    }
}

