/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import javax.inject.Inject;
import org.dashbuilder.client.cms.widget.PerspectivesExplorer;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class PerspectivesExplorerView
extends Composite
implements PerspectivesExplorer.View {
    @Inject
    @DataField
    Div mainDiv;
    PerspectivesExplorer presenter;

    public void init(PerspectivesExplorer presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)this.mainDiv);
    }

    private DivElement createItemDiv(Element[] items) {
        DivElement mi = Document.get().createDivElement();
        mi.setClassName("list-view-pf-main-info");
        mi.getStyle().setPaddingTop(5.0, Style.Unit.PX);
        mi.getStyle().setPaddingBottom(5.0, Style.Unit.PX);
        for (Element item : items) {
            mi.appendChild((com.google.gwt.dom.client.Node)item);
        }
        DivElement gi = Document.get().createDivElement();
        gi.setClassName("list-group-item");
        gi.appendChild((com.google.gwt.dom.client.Node)mi);
        return gi;
    }

    @Override
    public void addPerspective(String name, Command onClicked) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.getStyle().setCursor(Style.Cursor.POINTER);
        anchor.getStyle().setColor("black");
        anchor.getStyle().setProperty("fontSize", "larger");
        anchor.setInnerText(name);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onClicked.execute();
            }
        });
        SpanElement icon = Document.get().createSpanElement();
        icon.getStyle().setMarginRight(10.0, Style.Unit.PX);
        icon.setClassName("pficon-screen");
        icon.getStyle().setProperty("fontSize", "large");
        DivElement gi = this.createItemDiv(new Element[]{icon, anchor});
        this.mainDiv.appendChild((Node)gi);
    }

    @Override
    public void showEmpty(String message) {
        SpanElement span = Document.get().createSpanElement();
        span.setInnerText(message);
        DivElement gi = this.createItemDiv(new Element[]{span});
        this.mainDiv.appendChild((Node)gi);
    }
}

