/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.explorer;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import javax.inject.Inject;
import org.dashbuilder.client.cms.screen.explorer.ContentExplorerScreen;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class ContentExplorerScreenView
extends Composite
implements ContentExplorerScreen.View {
    @Inject
    @DataField
    Div tabContent;
    @Inject
    @DataField
    ListItem perspectivesTab;
    @Inject
    @DataField
    Anchor perspectivesAnchor;
    @Inject
    @DataField
    ListItem menusTab;
    @Inject
    @DataField
    Anchor menusAnchor;
    @Inject
    @DataField
    Div createDiv;
    @Inject
    @DataField
    Span createText;
    @Inject
    @DataField
    UnorderedList createMenu;
    ContentExplorerScreen presenter;

    public void init(ContentExplorerScreen presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setPerspectivesName(String name) {
        this.perspectivesAnchor.setTextContent(name);
    }

    @Override
    public void showPerspectives(IsWidget perspectivesExplorer) {
        this.perspectivesTab.setClassName("active");
        this.menusTab.setClassName("");
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.tabContent);
        this.tabContent.appendChild((org.jboss.errai.common.client.dom.Node)perspectivesExplorer.asWidget().getElement());
    }

    @Override
    public void showMenus(IsWidget menusExplorer) {
        this.menusTab.setClassName("active");
        this.perspectivesTab.setClassName("");
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.tabContent);
        this.tabContent.appendChild((org.jboss.errai.common.client.dom.Node)menusExplorer.asWidget().getElement());
    }

    @Override
    public void setMenusName(String name) {
        this.menusAnchor.setTextContent(name);
    }

    @Override
    public void setCreateName(String name) {
        this.createText.setTextContent(name);
    }

    @Override
    public void setCreateMenuVisible(boolean visible) {
        if (visible) {
            this.createDiv.getStyle().removeProperty("display");
        } else {
            this.createDiv.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void addCreateMenuEntry(String name, Command onClick) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.getStyle().setCursor(Style.Cursor.POINTER);
        anchor.setInnerText(name);
        LIElement li = Document.get().createLIElement();
        li.appendChild((Node)anchor);
        this.createMenu.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onClick.execute();
            }
        });
    }

    @EventHandler(value={"perspectivesAnchor"})
    public void onPerspectivesAnchorClick(ClickEvent event) {
        this.presenter.gotoPerspectives();
    }

    @EventHandler(value={"menusAnchor"})
    public void onMenusAnchorClick(ClickEvent event) {
        this.presenter.gotoMenus();
    }
}

