/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.jooq.ExecuteListenerProvider;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.conf.Settings;
import zipkin2.CheckResult;
import zipkin2.internal.Nullable;
import zipkin2.storage.AutocompleteTags;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.mysql.v1.DSLContexts;
import zipkin2.storage.mysql.v1.DataSourceCall;
import zipkin2.storage.mysql.v1.MySQLAutocompleteTags;
import zipkin2.storage.mysql.v1.MySQLSpanConsumer;
import zipkin2.storage.mysql.v1.MySQLSpanStore;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinDependencies;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;

public final class MySQLStorage
extends StorageComponent {
    final DataSource datasource;
    final DataSourceCall.Factory dataSourceCallFactory;
    final DSLContexts context;
    final boolean strictTraceId;
    final boolean searchEnabled;
    final List<String> autocompleteKeys;
    volatile Schema schema;

    public static Builder newBuilder() {
        return new Builder();
    }

    MySQLStorage(Builder builder) {
        this.datasource = builder.datasource;
        if (this.datasource == null) {
            throw new NullPointerException("datasource == null");
        }
        Executor executor = builder.executor;
        if (executor == null) {
            throw new NullPointerException("executor == null");
        }
        this.context = new DSLContexts(builder.settings, builder.listenerProvider);
        this.dataSourceCallFactory = new DataSourceCall.Factory(this.datasource, this.context, executor);
        this.strictTraceId = builder.strictTraceId;
        this.searchEnabled = builder.searchEnabled;
        this.autocompleteKeys = builder.autocompleteKeys;
    }

    public DataSource datasource() {
        return this.datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Schema schema() {
        if (this.schema == null) {
            MySQLStorage mySQLStorage = this;
            synchronized (mySQLStorage) {
                if (this.schema == null) {
                    this.schema = new Schema(this.datasource, this.context, this.strictTraceId);
                }
            }
        }
        return this.schema;
    }

    public SpanStore spanStore() {
        return new MySQLSpanStore(this, this.schema());
    }

    public ServiceAndSpanNames serviceAndSpanNames() {
        return new MySQLSpanStore(this, this.schema());
    }

    public AutocompleteTags autocompleteTags() {
        return new MySQLAutocompleteTags(this, this.schema());
    }

    public SpanConsumer spanConsumer() {
        return new MySQLSpanConsumer(this.dataSourceCallFactory, this.schema());
    }

    public CheckResult check() {
        try (Connection conn = this.datasource.getConnection();){
            this.context.get(conn).select(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).limit(1).execute();
        }
        catch (RuntimeException | SQLException e) {
            return CheckResult.failed((Throwable)e);
        }
        return CheckResult.OK;
    }

    public void close() {
    }

    void clear() {
        try (Connection conn = this.datasource.getConnection();){
            this.context.get(conn).truncate((Table)ZipkinSpans.ZIPKIN_SPANS).execute();
            this.context.get(conn).truncate((Table)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).execute();
            this.context.get(conn).truncate((Table)ZipkinDependencies.ZIPKIN_DEPENDENCIES).execute();
        }
        catch (RuntimeException | SQLException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        System.setProperty("org.jooq.no-logo", "true");
    }

    public static final class Builder
    extends StorageComponent.Builder {
        boolean strictTraceId = true;
        boolean searchEnabled = true;
        private DataSource datasource;
        private Settings settings = new Settings().withRenderSchema(Boolean.valueOf(false));
        private ExecuteListenerProvider listenerProvider;
        private Executor executor;
        List<String> autocompleteKeys = new ArrayList<String>();

        public Builder strictTraceId(boolean strictTraceId) {
            this.strictTraceId = strictTraceId;
            return this;
        }

        public Builder searchEnabled(boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public Builder autocompleteKeys(List<String> keys) {
            if (keys == null) {
                throw new NullPointerException("keys == null");
            }
            this.autocompleteKeys = keys;
            return this;
        }

        public Builder datasource(DataSource datasource) {
            if (datasource == null) {
                throw new NullPointerException("datasource == null");
            }
            this.datasource = datasource;
            return this;
        }

        public Builder settings(Settings settings) {
            if (settings == null) {
                throw new NullPointerException("settings == null");
            }
            this.settings = settings;
            return this;
        }

        public Builder listenerProvider(@Nullable ExecuteListenerProvider listenerProvider) {
            this.listenerProvider = listenerProvider;
            return this;
        }

        public Builder executor(Executor executor) {
            if (executor == null) {
                throw new NullPointerException("executor == null");
            }
            this.executor = executor;
            return this;
        }

        public MySQLStorage build() {
            return new MySQLStorage(this);
        }

        Builder() {
        }
    }
}

