/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.List;
import zipkin2.Call;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.internal.DateUtil;
import zipkin2.internal.HexCodec;
import zipkin2.storage.GroupByTraceId;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StrictTraceId;
import zipkin2.storage.mysql.v1.AggregateDependencies;
import zipkin2.storage.mysql.v1.DataSourceCall;
import zipkin2.storage.mysql.v1.MySQLStorage;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.SelectAnnotationServiceNames;
import zipkin2.storage.mysql.v1.SelectDependencies;
import zipkin2.storage.mysql.v1.SelectRemoteServiceNames;
import zipkin2.storage.mysql.v1.SelectSpanNames;
import zipkin2.storage.mysql.v1.SelectSpansAndAnnotations;

final class MySQLSpanStore
implements SpanStore,
ServiceAndSpanNames {
    final DataSourceCall.Factory dataSourceCallFactory;
    final Schema schema;
    final boolean strictTraceId;
    final boolean searchEnabled;
    final SelectSpansAndAnnotations.Factory selectFromSpansAndAnnotationsFactory;
    final Call.Mapper<List<Span>, List<List<Span>>> groupByTraceId;
    final DataSourceCall<List<String>> getServiceNamesCall;

    MySQLSpanStore(MySQLStorage storage, Schema schema) {
        this.dataSourceCallFactory = storage.dataSourceCallFactory;
        this.schema = schema;
        this.strictTraceId = storage.strictTraceId;
        this.searchEnabled = storage.searchEnabled;
        this.selectFromSpansAndAnnotationsFactory = new SelectSpansAndAnnotations.Factory(schema, this.strictTraceId);
        this.groupByTraceId = GroupByTraceId.create((boolean)this.strictTraceId);
        this.getServiceNamesCall = this.dataSourceCallFactory.create(new SelectAnnotationServiceNames());
    }

    public Call<List<List<Span>>> getTraces(QueryRequest request) {
        if (!this.searchEnabled) {
            return Call.emptyList();
        }
        Call result = this.dataSourceCallFactory.create(this.selectFromSpansAndAnnotationsFactory.create(request)).map(this.groupByTraceId);
        return this.strictTraceId ? result.map(StrictTraceId.filterTraces((QueryRequest)request)) : result;
    }

    public Call<List<Span>> getTrace(String hexTraceId) {
        long traceIdHigh = (hexTraceId = Span.normalizeTraceId((String)hexTraceId)).length() == 32 ? HexCodec.lowerHexToUnsignedLong((String)hexTraceId, (int)0) : 0L;
        long traceId = HexCodec.lowerHexToUnsignedLong((String)hexTraceId);
        Call result = this.dataSourceCallFactory.create(this.selectFromSpansAndAnnotationsFactory.create(traceIdHigh, traceId));
        return this.strictTraceId ? result.map(StrictTraceId.filterSpans((String)hexTraceId)) : result;
    }

    public Call<List<String>> getServiceNames() {
        if (!this.searchEnabled) {
            return Call.emptyList();
        }
        return this.getServiceNamesCall.clone();
    }

    public Call<List<String>> getRemoteServiceNames(String serviceName) {
        if (serviceName.isEmpty() || !this.searchEnabled || !this.schema.hasRemoteServiceName) {
            return Call.emptyList();
        }
        return this.dataSourceCallFactory.create(new SelectRemoteServiceNames(this.schema, serviceName));
    }

    public Call<List<String>> getSpanNames(String serviceName) {
        if (serviceName.isEmpty() || !this.searchEnabled) {
            return Call.emptyList();
        }
        return this.dataSourceCallFactory.create(new SelectSpanNames(this.schema, serviceName));
    }

    public Call<List<DependencyLink>> getDependencies(long endTs, long lookback) {
        if (endTs <= 0L) {
            throw new IllegalArgumentException("endTs <= 0");
        }
        if (lookback <= 0L) {
            throw new IllegalArgumentException("lookback <= 0");
        }
        if (this.schema.hasPreAggregatedDependencies) {
            return this.dataSourceCallFactory.create(new SelectDependencies(this.schema, DateUtil.getDays((long)endTs, (long)lookback)));
        }
        return this.dataSourceCallFactory.create(new AggregateDependencies(this.schema, endTs * 1000L - lookback * 1000L, endTs * 1000L));
    }
}

