/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import zipkin2.storage.mysql.v1.DSLContexts;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;

final class HasIpv6 {
    private static final Logger LOG = Logger.getLogger(HasIpv6.class.getName());

    HasIpv6() {
    }

    static boolean test(DataSource datasource, DSLContexts context) {
        block11: {
            boolean bl;
            block10: {
                Connection conn = datasource.getConnection();
                try {
                    DSLContext dsl = context.get(conn);
                    dsl.select(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6).from((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).limit(1).fetchAny();
                    bl = true;
                    if (conn == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DataAccessException e) {
                        if (e.sqlState().equals("42S22")) {
                            LOG.warning("zipkin_annotations.ipv6 doesn't exist, so Endpoint.ipv6 is not supported. Execute: alter table zipkin_annotations add `endpoint_ipv6` BINARY(16)");
                            return false;
                        }
                        HasIpv6.problemReading((Exception)((Object)e));
                        break block11;
                    }
                    catch (RuntimeException | SQLException e) {
                        HasIpv6.problemReading(e);
                    }
                }
                conn.close();
            }
            return bl;
        }
        return false;
    }

    static void problemReading(Exception e) {
        LOG.log(Level.WARNING, "problem reading zipkin_annotations.ipv6", e);
    }
}

