/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * This file is generated by jOOQ.
 */
package zipkin2.storage.mysql.v1.internal.generated;


import javax.annotation.Generated;

import org.jooq.Index;
import org.jooq.OrderField;
import org.jooq.impl.Internal;

import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinDependencies;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;


/**
 * A class modelling indexes of tables of the <code>zipkin</code> schema.
 */
@Generated(
    value = {
        "http://www.jooq.org",
        "jOOQ version:3.11.9"
    },
    comments = "This class is generated by jOOQ"
)
@SuppressWarnings({ "all", "unchecked", "rawtypes" })
public class Indexes {

    // -------------------------------------------------------------------------
    // INDEX definitions
    // -------------------------------------------------------------------------

    public static final Index ZIPKIN_ANNOTATIONS_A_KEY = Indexes0.ZIPKIN_ANNOTATIONS_A_KEY;
    public static final Index ZIPKIN_ANNOTATIONS_A_TYPE = Indexes0.ZIPKIN_ANNOTATIONS_A_TYPE;
    public static final Index ZIPKIN_ANNOTATIONS_ENDPOINT_SERVICE_NAME = Indexes0.ZIPKIN_ANNOTATIONS_ENDPOINT_SERVICE_NAME;
    public static final Index ZIPKIN_ANNOTATIONS_TRACE_ID = Indexes0.ZIPKIN_ANNOTATIONS_TRACE_ID;
    public static final Index ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH = Indexes0.ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH;
    public static final Index ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH_2 = Indexes0.ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH_2;
    public static final Index ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH_3 = Indexes0.ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH_3;
    public static final Index ZIPKIN_DEPENDENCIES_PRIMARY = Indexes0.ZIPKIN_DEPENDENCIES_PRIMARY;
    public static final Index ZIPKIN_SPANS_NAME = Indexes0.ZIPKIN_SPANS_NAME;
    public static final Index ZIPKIN_SPANS_PRIMARY = Indexes0.ZIPKIN_SPANS_PRIMARY;
    public static final Index ZIPKIN_SPANS_REMOTE_SERVICE_NAME = Indexes0.ZIPKIN_SPANS_REMOTE_SERVICE_NAME;
    public static final Index ZIPKIN_SPANS_START_TS = Indexes0.ZIPKIN_SPANS_START_TS;
    public static final Index ZIPKIN_SPANS_TRACE_ID_HIGH = Indexes0.ZIPKIN_SPANS_TRACE_ID_HIGH;

    // -------------------------------------------------------------------------
    // [#1459] distribute members to avoid static initialisers > 64kb
    // -------------------------------------------------------------------------

    private static class Indexes0 {
        public static Index ZIPKIN_ANNOTATIONS_A_KEY = Internal.createIndex("a_key", ZipkinAnnotations.ZIPKIN_ANNOTATIONS, new OrderField[] { ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY }, false);
        public static Index ZIPKIN_ANNOTATIONS_A_TYPE = Internal.createIndex("a_type", ZipkinAnnotations.ZIPKIN_ANNOTATIONS, new OrderField[] { ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE }, false);
        public static Index ZIPKIN_ANNOTATIONS_ENDPOINT_SERVICE_NAME = Internal.createIndex("endpoint_service_name", ZipkinAnnotations.ZIPKIN_ANNOTATIONS, new OrderField[] { ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME }, false);
        public static Index ZIPKIN_ANNOTATIONS_TRACE_ID = Internal.createIndex("trace_id", ZipkinAnnotations.ZIPKIN_ANNOTATIONS, new OrderField[] { ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY }, false);
        public static Index ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH = Internal.createIndex("trace_id_high", ZipkinAnnotations.ZIPKIN_ANNOTATIONS, new OrderField[] { ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP }, true);
        public static Index ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH_2 = Internal.createIndex("trace_id_high_2", ZipkinAnnotations.ZIPKIN_ANNOTATIONS, new OrderField[] { ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID }, false);
        public static Index ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH_3 = Internal.createIndex("trace_id_high_3", ZipkinAnnotations.ZIPKIN_ANNOTATIONS, new OrderField[] { ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID }, false);
        public static Index ZIPKIN_DEPENDENCIES_PRIMARY = Internal.createIndex("PRIMARY", ZipkinDependencies.ZIPKIN_DEPENDENCIES, new OrderField[] { ZipkinDependencies.ZIPKIN_DEPENDENCIES.DAY, ZipkinDependencies.ZIPKIN_DEPENDENCIES.PARENT, ZipkinDependencies.ZIPKIN_DEPENDENCIES.CHILD }, true);
        public static Index ZIPKIN_SPANS_NAME = Internal.createIndex("name", ZipkinSpans.ZIPKIN_SPANS, new OrderField[] { ZipkinSpans.ZIPKIN_SPANS.NAME }, false);
        public static Index ZIPKIN_SPANS_PRIMARY = Internal.createIndex("PRIMARY", ZipkinSpans.ZIPKIN_SPANS, new OrderField[] { ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, ZipkinSpans.ZIPKIN_SPANS.ID }, true);
        public static Index ZIPKIN_SPANS_REMOTE_SERVICE_NAME = Internal.createIndex("remote_service_name", ZipkinSpans.ZIPKIN_SPANS, new OrderField[] { ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME }, false);
        public static Index ZIPKIN_SPANS_START_TS = Internal.createIndex("start_ts", ZipkinSpans.ZIPKIN_SPANS, new OrderField[] { ZipkinSpans.ZIPKIN_SPANS.START_TS }, false);
        public static Index ZIPKIN_SPANS_TRACE_ID_HIGH = Internal.createIndex("trace_id_high", ZipkinSpans.ZIPKIN_SPANS, new OrderField[] { ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID }, false);
    }
}
