/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector.kafka;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.CheckResult;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorComponent;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.collector.kafka.KafkaCollectorWorker;
import zipkin2.storage.StorageComponent;

public final class KafkaCollector
extends CollectorComponent {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCollector.class);
    final LazyKafkaWorkers kafkaWorkers;
    final Properties properties;
    volatile AdminClient adminClient;

    public static Builder builder() {
        return new Builder();
    }

    KafkaCollector(Builder builder) {
        this.kafkaWorkers = new LazyKafkaWorkers(builder);
        this.properties = builder.properties;
    }

    public KafkaCollector start() {
        this.kafkaWorkers.get();
        return this;
    }

    public CheckResult check() {
        try {
            CheckResult failure = this.kafkaWorkers.failure.get();
            if (failure != null) {
                return failure;
            }
            KafkaFuture maybeClusterId = this.getAdminClient().describeCluster().clusterId();
            maybeClusterId.get(1L, TimeUnit.SECONDS);
            return CheckResult.OK;
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AdminClient getAdminClient() {
        if (this.adminClient == null) {
            KafkaCollector kafkaCollector = this;
            synchronized (kafkaCollector) {
                if (this.adminClient == null) {
                    this.adminClient = AdminClient.create((Properties)this.properties);
                }
            }
        }
        return this.adminClient;
    }

    public void close() {
        this.kafkaWorkers.close();
        if (this.adminClient != null) {
            this.adminClient.close(1L, TimeUnit.SECONDS);
        }
    }

    static final class LazyKafkaWorkers {
        final int streams;
        final Builder builder;
        final AtomicReference<CheckResult> failure = new AtomicReference();
        final CopyOnWriteArrayList<KafkaCollectorWorker> workers = new CopyOnWriteArrayList();
        volatile ExecutorService pool;

        LazyKafkaWorkers(Builder builder) {
            this.streams = builder.streams;
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExecutorService get() {
            if (this.pool == null) {
                LazyKafkaWorkers lazyKafkaWorkers = this;
                synchronized (lazyKafkaWorkers) {
                    if (this.pool == null) {
                        this.pool = this.compute();
                    }
                }
            }
            return this.pool;
        }

        void close() {
            ExecutorService maybePool = this.pool;
            if (maybePool == null) {
                return;
            }
            for (KafkaCollectorWorker worker : this.workers) {
                worker.stop();
            }
            maybePool.shutdown();
            try {
                if (!maybePool.awaitTermination(2L, TimeUnit.SECONDS)) {
                    maybePool.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        ExecutorService compute() {
            ExecutorService pool = this.streams == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(this.streams);
            for (int i = 0; i < this.streams; ++i) {
                KafkaCollectorWorker worker = new KafkaCollectorWorker(this.builder);
                this.workers.add(worker);
                pool.execute(this.guardFailures(worker));
            }
            return pool;
        }

        Runnable guardFailures(Runnable delegate) {
            return () -> {
                try {
                    delegate.run();
                }
                catch (InterruptException interruptException) {
                }
                catch (KafkaException e) {
                    if (e.getCause() instanceof ConfigException) {
                        e = (KafkaException)e.getCause();
                    }
                    LOG.error("Kafka worker exited with exception", (Throwable)e);
                    this.failure.set(CheckResult.failed((Throwable)e));
                }
                catch (RuntimeException e) {
                    LOG.error("Kafka worker exited with exception", (Throwable)e);
                    this.failure.set(CheckResult.failed((Throwable)e));
                }
                catch (Error e) {
                    LOG.error("Kafka worker exited with error", (Throwable)e);
                    this.failure.set(CheckResult.failed((Throwable)new RuntimeException(e)));
                }
            };
        }
    }

    public static final class Builder
    extends CollectorComponent.Builder {
        final Properties properties = new Properties();
        Collector.Builder delegate = Collector.newBuilder(KafkaCollector.class);
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;
        String topic = "zipkin";
        int streams = 1;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics.forTransport("kafka");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder topic(String topic) {
            if (topic == null) {
                throw new NullPointerException("topic == null");
            }
            this.topic = topic;
            return this;
        }

        public Builder bootstrapServers(String bootstrapServers) {
            if (bootstrapServers == null) {
                throw new NullPointerException("bootstrapServers == null");
            }
            this.properties.put("bootstrap.servers", bootstrapServers);
            return this;
        }

        public Builder groupId(String groupId) {
            if (groupId == null) {
                throw new NullPointerException("groupId == null");
            }
            this.properties.put("group.id", groupId);
            return this;
        }

        public Builder streams(int streams) {
            this.streams = streams;
            return this;
        }

        public final Builder overrides(Map<String, ?> overrides) {
            if (overrides == null) {
                throw new NullPointerException("overrides == null");
            }
            this.properties.putAll(overrides);
            return this;
        }

        public KafkaCollector build() {
            return new KafkaCollector(this);
        }

        Builder() {
            this.properties.put("group.id", "zipkin");
            this.properties.put("auto.offset.reset", "earliest");
            this.properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
            this.properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        }
    }
}

