/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics;

public class MicrometerReporterMetricsTest {
    MeterRegistry meterRegistry = new SimpleMeterRegistry();
    MicrometerReporterMetrics reporterMetrics = MicrometerReporterMetrics.create((MeterRegistry)this.meterRegistry);

    @Test
    public void expectedMetricsRegistered() {
        Assertions.assertThat((List)this.meterRegistry.getMeters()).extracting(Meter::getId).extracting(Meter.Id::getName).containsExactlyInAnyOrder((Object[])new String[]{"zipkin.reporter.messages.total", "zipkin.reporter.messages", "zipkin.reporter.spans.total", "zipkin.reporter.spans", "zipkin.reporter.spans.dropped", "zipkin.reporter.queue.spans", "zipkin.reporter.queue.bytes"});
    }

    @Test
    public void incrementMessagesDropped_sameExceptionTypeIsNotTaggedMoreThanOnce() {
        this.reporterMetrics.incrementMessagesDropped((Throwable)new RuntimeException("boo"));
        this.reporterMetrics.incrementMessagesDropped((Throwable)new RuntimeException("shh"));
        this.reporterMetrics.incrementMessagesDropped((Throwable)new IllegalStateException());
        Assertions.assertThat((Iterable)this.meterRegistry.get("zipkin.reporter.messages.dropped").counters()).hasSize(2);
        Assertions.assertThat((double)this.meterRegistry.get("zipkin.reporter.messages.dropped").tag("cause", RuntimeException.class.getSimpleName()).counter().count()).isEqualTo(2.0);
        Assertions.assertThat((double)this.meterRegistry.get("zipkin.reporter.messages.dropped").tag("cause", IllegalStateException.class.getSimpleName()).counter().count()).isEqualTo(1.0);
        double messagesDroppedTotal = this.meterRegistry.get("zipkin.reporter.messages.dropped").counters().stream().mapToDouble(Counter::count).sum();
        Assertions.assertThat((double)messagesDroppedTotal).isEqualTo(3.0);
    }

    @Test
    public void gaugesSurviveGc() {
        this.reporterMetrics.updateQueuedBytes(53);
        this.reporterMetrics.updateQueuedSpans(2);
        System.gc();
        Assertions.assertThat((double)this.meterRegistry.get("zipkin.reporter.queue.bytes").gauge().value()).isEqualTo(53.0);
        Assertions.assertThat((double)this.meterRegistry.get("zipkin.reporter.queue.spans").gauge().value()).isEqualTo(2.0);
    }
}

