/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ksql;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class BasicKSQLHttpClient
implements Closeable {
    public static final String UTF_8 = "utf-8";
    private final String jsonData;
    private final Map<String, Object> formData;
    private final String type;
    private final Map<String, String> headers;
    private final URL url;
    private HttpURLConnection connection;
    private final int timeout;
    private boolean connected;

    public BasicKSQLHttpClient(String url, String jsonData, Map<String, Object> formData, String type, Map<String, String> headers, int timeout) throws IOException {
        this.url = new URL(url);
        this.jsonData = jsonData;
        this.formData = formData;
        this.type = type;
        this.headers = headers;
        this.timeout = timeout;
        this.connected = false;
    }

    @Override
    public void close() throws IOException {
        this.connected = false;
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private void writeOutput(String data) throws IOException {
        try (OutputStream os = this.connection.getOutputStream();){
            byte[] input = data.getBytes(UTF_8);
            os.write(input);
        }
    }

    public String connect() throws IOException {
        int status = this.createConnection();
        boolean isStatusOk = this.isStatusOk(status);
        return IOUtils.toString((InputStream)(isStatusOk ? this.connection.getInputStream() : this.connection.getErrorStream()), (String)UTF_8);
    }

    public void connectAsync(BasicHTTPClientResponse onResponse) throws IOException {
        int status = this.createConnection();
        boolean isStatusOk = this.isStatusOk(status);
        long start = System.currentTimeMillis();
        try (InputStreamReader in = new InputStreamReader(this.connection.getInputStream(), UTF_8);
             BufferedReader br = new BufferedReader(in);){
            while (this.connected && (this.timeout == -1 || System.currentTimeMillis() - start < (long)this.timeout)) {
                String responseLine;
                if (!br.ready() || (responseLine = br.readLine()) == null || responseLine.isEmpty()) continue;
                if (isStatusOk) {
                    onResponse.onMessage(status, responseLine.trim());
                    continue;
                }
                onResponse.onError(status, responseLine.trim());
            }
        }
    }

    private boolean isStatusOk(int status) {
        return status >= 200 && status < 300;
    }

    private int createConnection() throws IOException {
        this.connection = (HttpURLConnection)this.url.openConnection();
        this.connection.setRequestMethod(this.type);
        this.headers.forEach((k, v) -> this.connection.setRequestProperty((String)k, (String)v));
        this.connection.setDoOutput(true);
        if (this.jsonData != null && !this.jsonData.isEmpty()) {
            this.writeOutput(this.jsonData);
        } else if (this.formData != null && !this.formData.isEmpty()) {
            String queryStringParams = this.formData.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
            this.writeOutput(queryStringParams);
        }
        this.connected = true;
        return this.connection.getResponseCode();
    }

    static class Builder {
        private String url;
        private String json;
        private Map<String, Object> formData = new HashMap<String, Object>();
        private String type;
        private Map<String, String> headers = new HashMap<String, String>();
        private int timeout = -1;

        Builder() {
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withJson(String json) {
            this.json = json;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withHeader(String header, String value) {
            this.headers.put(header, value);
            return this;
        }

        public Builder withFormData(String name, Object value) {
            this.formData.put(name, value);
            return this;
        }

        public BasicKSQLHttpClient build() throws IOException {
            return new BasicKSQLHttpClient(this.url, this.json, this.formData, this.type, this.headers, this.timeout);
        }
    }

    static interface BasicHTTPClientResponse {
        public void onMessage(int var1, String var2);

        public void onError(int var1, String var2);
    }
}

