/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.interpreter.jupyter.proto.CancelRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.CancelResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.CompletionRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.CompletionResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteStatus;
import org.apache.zeppelin.interpreter.jupyter.proto.JupyterKernelGrpc;
import org.apache.zeppelin.interpreter.jupyter.proto.OutputType;
import org.apache.zeppelin.interpreter.jupyter.proto.StatusRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.StatusResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.StopRequest;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JupyterKernelClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JupyterKernelClient.class.getName());
    private static final Pattern SHINY_LISTENING_PATTERN = Pattern.compile(".*Listening on (http:\\S*).*", 32);
    private final ManagedChannel channel;
    private final JupyterKernelGrpc.JupyterKernelBlockingStub blockingStub;
    private final JupyterKernelGrpc.JupyterKernelStub asyncStub;
    private volatile boolean maybeKernelFailed = false;
    private Properties properties;
    private InterpreterContext context;
    private String kernel;

    public JupyterKernelClient(String host, int port, String kernel) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(true), new Properties(), kernel);
    }

    public JupyterKernelClient(ManagedChannelBuilder<?> channelBuilder, Properties properties, String kernel) {
        this.channel = channelBuilder.build();
        this.blockingStub = JupyterKernelGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = JupyterKernelGrpc.newStub((Channel)this.channel);
        this.properties = properties;
        this.kernel = kernel;
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void setInterpreterContext(InterpreterContext context) {
        this.context = context;
    }

    private boolean checkForShinyApp(String response) throws IOException {
        Matcher matcher;
        String intpClassName = this.context.getInterpreterClassName();
        if (intpClassName != null && (intpClassName.equals("org.apache.zeppelin.r.ShinyInterpreter") || intpClassName.equals("org.apache.zeppelin.spark.SparkShinyInterpreter")) && (matcher = SHINY_LISTENING_PATTERN.matcher(response)).matches()) {
            String url = matcher.group(1);
            LOGGER.info("Matching shiny app url: {}", (Object)url);
            this.context.out.clear();
            String defaultHeight = this.properties.getProperty("zeppelin.R.shiny.iframe_height", "500px");
            String height = this.context.getLocalProperties().getOrDefault("height", defaultHeight);
            String defaultWidth = this.properties.getProperty("zeppelin.R.shiny.iframe_width", "100%");
            String width = this.context.getLocalProperties().getOrDefault("width", defaultWidth);
            this.context.out.write("\n%html <iframe src=\"" + url + "\" height =\"" + height + "\" width=\"" + width + "\" frameBorder=\"0\"></iframe>");
            this.context.out.flush();
            this.context.out.write("\n%text ");
            this.context.getIntpEventClient().checkpointOutput(this.context.getNoteId(), this.context.getParagraphId());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResponse stream_execute(ExecuteRequest request, final InterpreterOutputStream interpreterOutput) {
        final ExecuteResponse.Builder finalResponseBuilder = ExecuteResponse.newBuilder().setStatus(ExecuteStatus.SUCCESS);
        final AtomicBoolean completedFlag = new AtomicBoolean(false);
        this.maybeKernelFailed = false;
        LOGGER.debug("stream_execute code:\n" + request.getCode());
        this.asyncStub.execute(request, new StreamObserver<ExecuteResponse>(){
            OutputType lastOutputType = null;

            public void onNext(ExecuteResponse executeResponse) {
                LOGGER.debug("Interpreter Streaming Output: " + (Object)((Object)executeResponse.getType()) + "\t" + executeResponse.getOutput());
                switch (executeResponse.getType()) {
                    case TEXT: {
                        try {
                            if (JupyterKernelClient.this.checkForShinyApp(executeResponse.getOutput())) break;
                            if (executeResponse.getOutput().startsWith("%")) {
                                interpreterOutput.write(executeResponse.getOutput().getBytes());
                            } else {
                                InterpreterResultMessageOutput curOutput = interpreterOutput.getInterpreterOutput().getCurrentOutput();
                                if (curOutput != null && curOutput.getType() != InterpreterResult.Type.HTML && curOutput.getType() != InterpreterResult.Type.TEXT) {
                                    interpreterOutput.write("%text ".getBytes());
                                }
                                if (JupyterKernelClient.this.kernel.equals("ir") && executeResponse.getOutput().contains("<script type=\"text/javascript\">")) {
                                    interpreterOutput.write("\n%html ".getBytes());
                                }
                                interpreterOutput.write(executeResponse.getOutput().getBytes());
                            }
                            interpreterOutput.getInterpreterOutput().flush();
                        }
                        catch (IOException e) {
                            LOGGER.error("Unexpected IOException", (Throwable)e);
                        }
                        break;
                    }
                    case PNG: 
                    case JPEG: {
                        try {
                            interpreterOutput.write(("\n%img " + executeResponse.getOutput()).getBytes());
                            interpreterOutput.getInterpreterOutput().flush();
                        }
                        catch (IOException e) {
                            LOGGER.error("Unexpected IOException", (Throwable)e);
                        }
                        break;
                    }
                    case HTML: {
                        try {
                            interpreterOutput.write(("\n%html " + executeResponse.getOutput()).getBytes());
                            interpreterOutput.getInterpreterOutput().flush();
                        }
                        catch (IOException e) {
                            LOGGER.error("Unexpected IOException", (Throwable)e);
                        }
                        break;
                    }
                    case CLEAR: {
                        interpreterOutput.getInterpreterOutput().clear();
                        break;
                    }
                    default: {
                        LOGGER.error("Unrecognized type:" + (Object)((Object)executeResponse.getType()));
                    }
                }
                this.lastOutputType = executeResponse.getType();
                if (executeResponse.getStatus() == ExecuteStatus.ERROR) {
                    finalResponseBuilder.setStatus(ExecuteStatus.ERROR);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable throwable) {
                try {
                    if (finalResponseBuilder.getStatus() != null && finalResponseBuilder.getStatus() != ExecuteStatus.ERROR) {
                        interpreterOutput.getInterpreterOutput().write("\n%text " + ExceptionUtils.getStackTrace((Throwable)throwable));
                        interpreterOutput.getInterpreterOutput().flush();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected IOException", (Throwable)e);
                }
                LOGGER.error("Fail to call IPython grpc", throwable);
                finalResponseBuilder.setStatus(ExecuteStatus.ERROR);
                JupyterKernelClient.this.maybeKernelFailed = true;
                completedFlag.set(true);
                AtomicBoolean atomicBoolean = completedFlag;
                synchronized (atomicBoolean) {
                    completedFlag.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted() {
                AtomicBoolean atomicBoolean = completedFlag;
                synchronized (atomicBoolean) {
                    try {
                        LOGGER.debug("stream_execute is completed");
                        interpreterOutput.getInterpreterOutput().flush();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unexpected IOException", (Throwable)e);
                    }
                    completedFlag.set(true);
                    completedFlag.notify();
                }
            }
        });
        AtomicBoolean atomicBoolean = completedFlag;
        synchronized (atomicBoolean) {
            if (!completedFlag.get()) {
                try {
                    completedFlag.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.error("Unexpected Interruption", (Throwable)e);
                }
            }
        }
        return finalResponseBuilder.build();
    }

    public ExecuteResponse block_execute(ExecuteRequest request) {
        ExecuteResponse.Builder responseBuilder = ExecuteResponse.newBuilder();
        responseBuilder.setStatus(ExecuteStatus.SUCCESS);
        Iterator<ExecuteResponse> iter = this.blockingStub.execute(request);
        StringBuilder outputBuilder = new StringBuilder();
        try {
            while (iter.hasNext()) {
                ExecuteResponse nextResponse = iter.next();
                if (nextResponse.getStatus() == ExecuteStatus.ERROR) {
                    responseBuilder.setStatus(ExecuteStatus.ERROR);
                }
                outputBuilder.append(nextResponse.getOutput());
            }
            responseBuilder.setOutput(outputBuilder.toString());
        }
        catch (Exception e) {
            responseBuilder.setStatus(ExecuteStatus.ERROR);
            responseBuilder.setOutput(outputBuilder.toString());
        }
        return responseBuilder.build();
    }

    public CancelResponse cancel(CancelRequest request) {
        return this.blockingStub.cancel(request);
    }

    public CompletionResponse complete(CompletionRequest request) {
        return this.blockingStub.complete(request);
    }

    public StatusResponse status(StatusRequest request) {
        return this.blockingStub.status(request);
    }

    public void stop(StopRequest request) {
        this.asyncStub.stop(request, null);
    }

    public boolean isMaybeKernelFailed() {
        return this.maybeKernelFailed;
    }

    public static void main(String[] args) {
        JupyterKernelClient client = new JupyterKernelClient("localhost", 50053, "python");
        client.status(StatusRequest.newBuilder().build());
        ExecuteResponse response = client.block_execute(ExecuteRequest.newBuilder().setCode("abcd=2").build());
        System.out.println(response.getOutput());
    }
}

