/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.jupyter.JupyterKernelInterpreter;
import org.apache.zeppelin.jupyter.JupyterZeppelinContext;

public class JupyterInterpreter
extends AbstractInterpreter {
    private Map<String, JupyterKernelInterpreter> kernelInterpreterMap = new HashMap<String, JupyterKernelInterpreter>();

    public JupyterInterpreter(Properties properties) {
        super(properties);
    }

    public ZeppelinContext getZeppelinContext() {
        return new JupyterZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        String kernel = (String)context.getLocalProperties().get("kernel");
        if (kernel == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "No kernel is specified");
        }
        JupyterKernelInterpreter kernelInterpreter = null;
        Map<String, JupyterKernelInterpreter> map = this.kernelInterpreterMap;
        synchronized (map) {
            if (this.kernelInterpreterMap.containsKey(kernel)) {
                kernelInterpreter = this.kernelInterpreterMap.get(kernel);
            } else {
                kernelInterpreter = new JupyterKernelInterpreter(kernel, this.properties);
                kernelInterpreter.open();
                this.kernelInterpreterMap.put(kernel, kernelInterpreter);
            }
        }
        return kernelInterpreter.interpret(st, context);
    }

    public void open() throws InterpreterException {
    }

    public void close() throws InterpreterException {
        for (JupyterKernelInterpreter kernelInterpreter : this.kernelInterpreterMap.values()) {
            kernelInterpreter.close();
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        String kernel = (String)context.getLocalProperties().get("kernel");
        if (kernel == null) {
            throw new InterpreterException("No kernel is specified");
        }
        JupyterKernelInterpreter kernelInterpreter = this.kernelInterpreterMap.get(kernel);
        if (kernelInterpreter == null) {
            throw new InterpreterException("No such interpreter: " + kernel);
        }
        kernelInterpreter.cancel(context);
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        String kernel = (String)context.getLocalProperties().get("kernel");
        if (kernel == null) {
            throw new InterpreterException("No kernel is specified");
        }
        JupyterKernelInterpreter kernelInterpreter = this.kernelInterpreterMap.get(kernel);
        if (kernelInterpreter == null) {
            throw new InterpreterException("No such interpreter: " + kernel);
        }
        return kernelInterpreter.getProgress(context);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext context) throws InterpreterException {
        String kernel = (String)context.getLocalProperties().get("kernel");
        if (kernel == null) {
            throw new InterpreterException("No kernel is specified");
        }
        JupyterKernelInterpreter kernelInterpreter = this.kernelInterpreterMap.get(kernel);
        if (kernelInterpreter == null) {
            throw new InterpreterException("No such interpreter: " + kernel);
        }
        return kernelInterpreter.completion(buf, cursor, context);
    }
}

