/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ignite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.ignite.IgniteInterpreterUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteSqlInterpreter
extends Interpreter {
    private static final String IGNITE_JDBC_DRIVER_NAME = "org.apache.ignite.IgniteJdbcDriver";
    static final String IGNITE_JDBC_URL = "ignite.jdbc.url";
    private Logger logger = LoggerFactory.getLogger(IgniteSqlInterpreter.class);
    private Connection conn;
    private Throwable connEx;
    private Statement curStmt;

    public IgniteSqlInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        try {
            Class.forName(IGNITE_JDBC_DRIVER_NAME);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Can't find Ignite JDBC driver", (Throwable)e);
            this.connEx = e;
            return;
        }
        try {
            this.logger.info("connect to " + this.getProperty(IGNITE_JDBC_URL));
            this.conn = DriverManager.getConnection(this.getProperty(IGNITE_JDBC_URL));
            this.connEx = null;
            this.logger.info("Successfully created JDBC connection");
        }
        catch (Exception e) {
            this.logger.error("Can't open connection: ", (Throwable)e);
            this.connEx = e;
        }
    }

    public void close() throws InterpreterException {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new InterpreterException((Throwable)e);
        }
        finally {
            this.conn = null;
            this.connEx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String st, InterpreterContext context) {
        if (this.connEx != null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, this.connEx.getMessage());
        }
        StringBuilder msg = new StringBuilder("%table ");
        try (Statement stmt = this.conn.createStatement();){
            this.curStmt = stmt;
            try (ResultSet res = stmt.executeQuery(st);){
                int i;
                ResultSetMetaData md = res.getMetaData();
                for (i = 1; i <= md.getColumnCount(); ++i) {
                    if (i > 1) {
                        msg.append('\t');
                    }
                    msg.append(md.getColumnName(i));
                }
                msg.append('\n');
                while (res.next()) {
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        msg.append(res.getString(i));
                        if (i == md.getColumnCount()) continue;
                        msg.append('\t');
                    }
                    msg.append('\n');
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in IgniteSqlInterpreter while InterpreterResult interpret: ", (Throwable)e);
            InterpreterResult interpreterResult = IgniteInterpreterUtils.buildErrorResult(e);
            return interpreterResult;
        }
        finally {
            this.curStmt = null;
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, msg.toString());
    }

    public void cancel(InterpreterContext context) {
        if (this.curStmt != null) {
            try {
                this.curStmt.cancel();
            }
            catch (SQLException e) {
                this.logger.info("No-op while cancel in IgniteSqlInterpreter", (Throwable)e);
            }
            finally {
                this.curStmt = null;
            }
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(IgniteSqlInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return new LinkedList<InterpreterCompletion>();
    }
}

