/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.groovy;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.xml.MarkupBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.groovy.GroovyZeppelinContext;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.slf4j.Logger;

public class GObject
extends GroovyObjectSupport {
    Logger log;
    StringWriter out;
    Properties props;
    InterpreterContext interpreterContext;
    Map<String, Object> bindings;
    GroovyZeppelinContext z;

    public GObject(Logger log, StringWriter out, Properties p, InterpreterContext ctx, Map<String, Object> bindings) {
        this.log = log;
        this.out = out;
        this.interpreterContext = ctx;
        this.props = p;
        this.bindings = bindings;
        this.z = new GroovyZeppelinContext(null, 1000);
        this.z.setInterpreterContext(this.interpreterContext);
    }

    public Object getProperty(String key) {
        if ("log".equals(key)) {
            return this.log;
        }
        return this.props.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        throw new RuntimeException("Set properties not supported: " + key + "=" + value);
    }

    public Properties getProperties() {
        return this.props;
    }

    private void startOutputType(String type) {
        StringBuffer sb = this.out.getBuffer();
        if (sb.length() > 0) {
            if (sb.length() < type.length() || !type.equals(sb.substring(0, type.length()))) {
                this.log.error("try to start output `" + type + "` after non-" + type + " started");
            }
        } else {
            this.out.append(type);
            this.out.append('\n');
        }
    }

    public GUI getGui() {
        return this.z.getGui();
    }

    @ZeppelinApi
    public Object input(String name) {
        return this.z.input(name, "");
    }

    @ZeppelinApi
    public Object input(String name, Object defaultValue) {
        return this.z.input(name, defaultValue);
    }

    private OptionInput.ParamOption[] toParamOptions(Map<Object, String> options) {
        OptionInput.ParamOption[] paramOptions = new OptionInput.ParamOption[options.size()];
        int i = 0;
        for (Map.Entry<Object, String> e : options.entrySet()) {
            paramOptions[i++] = new OptionInput.ParamOption(e.getKey(), e.getValue());
        }
        return paramOptions;
    }

    @ZeppelinApi
    public Object select(String name, Map<Object, String> options) {
        return this.z.select(name, "", this.toParamOptions(options));
    }

    @ZeppelinApi
    public Object select(String name, Object defaultValue, Map<Object, String> options) {
        return this.z.select(name, defaultValue, this.toParamOptions(options));
    }

    @ZeppelinApi
    public Collection<Object> checkbox(String name, Map<Object, String> options) {
        return this.z.checkbox(name, new ArrayList<Object>(options.keySet()), this.toParamOptions(options));
    }

    @ZeppelinApi
    public Collection<Object> checkbox(String name, Collection<Object> defaultChecked, Map<Object, String> options) {
        return this.z.checkbox(name, new ArrayList<Object>(defaultChecked), this.toParamOptions(options));
    }

    public Object get(String varName) {
        return this.bindings.get(varName);
    }

    public Object get(String varName, Object defValue) {
        return this.bindings.containsKey(varName) ? this.bindings.get(varName) : defValue;
    }

    public Object put(String varName, Object newValue) {
        return this.bindings.put(varName, newValue);
    }

    public MarkupBuilder html() {
        this.startOutputType("%angular");
        return new MarkupBuilder((Writer)this.out);
    }

    public void table(Object obj) {
        if (obj == null) {
            return;
        }
        StringBuffer sb = this.out.getBuffer();
        this.startOutputType("%table");
        if (obj instanceof Closure) {
            obj = ((Closure)obj).call();
        }
        if (obj instanceof Collection) {
            int count = 0;
            for (Object row : (Collection)obj) {
                ++count;
                boolean rowStarted = false;
                if (row instanceof Collection) {
                    for (Object field : (Collection)row) {
                        if (rowStarted) {
                            sb.append('\t');
                        }
                        sb.append(field);
                        rowStarted = true;
                    }
                } else {
                    sb.append(row);
                }
                sb.append('\n');
            }
        } else {
            throw new RuntimeException("Not supported table value :" + obj.getClass());
        }
    }

    private AngularObject getAngularObject(String name) {
        AngularObject ao;
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        String noteId = this.interpreterContext.getNoteId();
        AngularObject paragraphAo = registry.get(name, noteId, this.interpreterContext.getParagraphId());
        AngularObject noteAo = registry.get(name, noteId, null);
        AngularObject angularObject = ao = paragraphAo != null ? paragraphAo : noteAo;
        if (ao == null) {
            ao = registry.get(name, null, null);
        }
        return ao;
    }

    public Object angular(String name) {
        return this.z.angular(name);
    }

    public void angularBind(String name, Object o, String noteId) {
        this.z.angularBind(name, o, noteId);
    }

    public void angularBind(String name, Object o) {
        this.angularBind(name, o, this.interpreterContext.getNoteId());
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId) throws IOException {
        this.z.run(noteId, paragraphId);
    }

    @ZeppelinApi
    public void run(String paragraphId) throws IOException {
        this.z.run(paragraphId);
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId, InterpreterContext context) throws IOException {
        this.z.run(noteId, paragraphId, context);
    }

    public void runNote(String noteId) throws IOException {
        this.z.runNote(noteId);
    }

    public void runNote(String noteId, InterpreterContext context) throws IOException {
        this.z.runNote(noteId, context);
    }

    @ZeppelinApi
    public void runAll() throws IOException {
        this.z.runAll(this.interpreterContext);
    }

    @ZeppelinApi
    public void runAll(InterpreterContext context) throws IOException {
        this.z.runNote(context.getNoteId());
    }
}

