/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.groovy;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zeppelin.groovy.GObject;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyInterpreter.class);
    GroovyShell shell = null;
    Map<String, Object> sharedBindings = new ConcurrentHashMap<String, Object>();
    Map<String, Class<Script>> scriptCache = Collections.synchronizedMap(new WeakHashMap(100));
    private static Set<String> predefinedBindings = new HashSet<String>();

    public GroovyInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        CompilerConfiguration conf = new CompilerConfiguration();
        conf.setDebug(true);
        this.shell = new GroovyShell(conf);
        String classes = this.getProperty("GROOVY_CLASSES");
        if (classes == null || classes.length() == 0) {
            try {
                File jar = new File(GroovyInterpreter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                classes = new File(jar.getParentFile(), "classes").toString();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        LOGGER.info("groovy classes classpath: " + classes);
        if (classes != null && classes.length() > 0) {
            File fClasses = new File(classes);
            if (!fClasses.exists()) {
                fClasses.mkdirs();
            }
            this.shell.getClassLoader().addClasspath(classes);
        }
    }

    public void close() {
        this.shell = null;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(GroovyInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), 10);
    }

    private Job getRunningJob(String paragraphId) {
        return this.getScheduler().getJob(paragraphId);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    Script getGroovyScript(String id, String scriptText) {
        if (this.shell == null) {
            throw new RuntimeException("Groovy Shell is not initialized: null");
        }
        try {
            Class<Object> clazz = this.scriptCache.get(scriptText);
            if (clazz == null) {
                String scriptName = id + "_" + Long.toHexString(scriptText.hashCode()) + ".groovy";
                clazz = this.shell.parse(scriptText, scriptName).getClass();
                this.scriptCache.put(scriptText, clazz);
            }
            Script script = clazz.newInstance();
            return script;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to parse groovy script: " + t, t);
        }
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        try {
            Script script = this.getGroovyScript(contextInterpreter.getParagraphId(), cmd);
            Job runningJob = this.getRunningJob(contextInterpreter.getParagraphId());
            runningJob.info().put("CURRENT_THREAD", Thread.currentThread());
            Map bindings = script.getBinding().getVariables();
            bindings.clear();
            StringWriter out = new StringWriter((int)((double)cmd.length() * 1.75));
            bindings.putAll(this.sharedBindings);
            bindings.put("g", new GObject(LOGGER, out, this.getProperties(), contextInterpreter, bindings));
            bindings.put("out", new PrintWriter((Writer)out, true));
            script.run();
            for (Map.Entry e : bindings.entrySet()) {
                if (predefinedBindings.contains(e.getKey())) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("groovy script variable " + e);
                }
                this.sharedBindings.put((String)e.getKey(), e.getValue());
            }
            bindings.clear();
            InterpreterResult result = new InterpreterResult(InterpreterResult.Code.SUCCESS, out.toString());
            return result;
        }
        catch (Throwable t) {
            t = StackTraceUtils.deepSanitize((Throwable)t);
            String msg = t.toString() + "\n at " + t.getStackTrace()[0];
            LOGGER.error("Failed to run script: " + t + "\n" + cmd + "\n", t);
            return new InterpreterResult(InterpreterResult.Code.ERROR, msg);
        }
    }

    public void cancel(InterpreterContext context) {
        Map info;
        Object object;
        Job runningJob = this.getRunningJob(context.getParagraphId());
        if (runningJob != null && (object = (info = runningJob.info()).get("CURRENT_THREAD")) instanceof Thread) {
            try {
                Thread t = (Thread)object;
                t.dumpStack();
                t.interrupt();
            }
            catch (Throwable t) {
                LOGGER.error("Failed to cancel script: " + t, t);
            }
        }
    }

    static {
        predefinedBindings.add("g");
        predefinedBindings.add("out");
    }
}

