/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.geode;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.pdx.PdxInstance;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeOqlInterpreter
extends Interpreter {
    private Logger logger = LoggerFactory.getLogger(GeodeOqlInterpreter.class);
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final char WHITESPACE = ' ';
    private static final String TABLE_MAGIC_TAG = "%table ";
    private ClientCache clientCache = null;
    private QueryService queryService = null;
    private Exception exceptionOnConnect;
    private int maxResult;

    public GeodeOqlInterpreter(Properties property) {
        super(property);
    }

    protected ClientCache getClientCache() {
        String locatorHost = this.getProperty("geode.locator.host");
        int locatorPort = Integer.valueOf(this.getProperty("geode.locator.port"));
        ClientCache clientCache = new ClientCacheFactory().addPoolLocator(locatorHost, locatorPort).create();
        return clientCache;
    }

    public void open() {
        this.logger.info("Geode open connection called!");
        this.close();
        try {
            this.maxResult = Integer.valueOf(this.getProperty("geode.max.result"));
            this.clientCache = this.getClientCache();
            this.queryService = this.clientCache.getQueryService();
            this.exceptionOnConnect = null;
            this.logger.info("Successfully created Geode connection");
        }
        catch (Exception e) {
            this.logger.error("Cannot open connection", (Throwable)e);
            this.exceptionOnConnect = e;
        }
    }

    public void close() {
        try {
            if (this.clientCache != null) {
                this.clientCache.close();
            }
            if (this.queryService != null) {
                this.queryService.closeCqs();
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot close connection", (Throwable)e);
        }
        finally {
            this.clientCache = null;
            this.queryService = null;
            this.exceptionOnConnect = null;
        }
    }

    private InterpreterResult executeOql(String oql) {
        try {
            if (this.getExceptionOnConnect() != null) {
                return new InterpreterResult(InterpreterResult.Code.ERROR, this.getExceptionOnConnect().getMessage());
            }
            SelectResults results = (SelectResults)this.getQueryService().newQuery(oql).execute();
            StringBuilder msg = new StringBuilder(TABLE_MAGIC_TAG);
            boolean isTableHeaderSet = false;
            Iterator iterator = results.iterator();
            int rowDisplayCount = 0;
            while (iterator.hasNext() && rowDisplayCount < this.getMaxResult()) {
                Object entry = iterator.next();
                ++rowDisplayCount;
                if (entry instanceof Number) {
                    this.handleNumberEntry(isTableHeaderSet, entry, msg);
                } else if (entry instanceof Struct) {
                    this.handleStructEntry(isTableHeaderSet, entry, msg);
                } else if (entry instanceof PdxInstance) {
                    this.handlePdxInstanceEntry(isTableHeaderSet, entry, msg);
                } else {
                    this.handleUnsupportedTypeEntry(isTableHeaderSet, entry, msg);
                }
                isTableHeaderSet = true;
                msg.append('\n');
            }
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, msg.toString());
        }
        catch (Exception ex) {
            this.logger.error("Cannot run " + oql, (Throwable)ex);
            return new InterpreterResult(InterpreterResult.Code.ERROR, ex.getMessage());
        }
    }

    private String replaceReservedChars(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.replace('\t', ' ').replace('\n', ' ');
    }

    private void handleStructEntry(boolean isHeaderSet, Object entry, StringBuilder msg) {
        Struct struct = (Struct)entry;
        if (!isHeaderSet) {
            for (String titleName : struct.getStructType().getFieldNames()) {
                msg.append(this.replaceReservedChars(titleName)).append('\t');
            }
            msg.append('\n');
        }
        for (String titleName : struct.getStructType().getFieldNames()) {
            msg.append(this.replaceReservedChars("" + struct.get(titleName))).append('\t');
        }
    }

    private void handlePdxInstanceEntry(boolean isHeaderSet, Object entry, StringBuilder msg) {
        PdxInstance pdxEntry = (PdxInstance)entry;
        if (!isHeaderSet) {
            for (String titleName : pdxEntry.getFieldNames()) {
                msg.append(this.replaceReservedChars(titleName)).append('\t');
            }
            msg.append('\n');
        }
        for (String titleName : pdxEntry.getFieldNames()) {
            msg.append(this.replaceReservedChars("" + pdxEntry.getField(titleName))).append('\t');
        }
    }

    private void handleNumberEntry(boolean isHeaderSet, Object entry, StringBuilder msg) {
        if (!isHeaderSet) {
            msg.append("Result").append('\n');
        }
        msg.append((Number)entry);
    }

    private void handleUnsupportedTypeEntry(boolean isHeaderSet, Object entry, StringBuilder msg) {
        if (!isHeaderSet) {
            msg.append("Unsuppoted Type").append('\n');
        }
        msg.append("" + entry);
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        this.logger.info("Run OQL command '{}'", (Object)cmd);
        return this.executeOql(cmd);
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(GeodeOqlInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    QueryService getQueryService() {
        return this.queryService;
    }

    Exception getExceptionOnConnect() {
        return this.exceptionOnConnect;
    }
}

