/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.elasticsearch.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.elasticsearch.action.ActionResponse;
import org.apache.zeppelin.elasticsearch.action.AggWrapper;
import org.apache.zeppelin.elasticsearch.action.HitWrapper;
import org.apache.zeppelin.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;

public class TransportBasedClient
implements ElasticsearchClient {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Client client;

    public TransportBasedClient(Properties props) throws UnknownHostException {
        String host = props.getProperty("elasticsearch.host");
        int port = Integer.parseInt(props.getProperty("elasticsearch.port"));
        String clusterName = props.getProperty("elasticsearch.cluster.name");
        Settings settings = Settings.settingsBuilder().put("cluster.name", clusterName).put(props).build();
        this.client = TransportClient.builder().settings(settings).build().addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host), port));
    }

    @Override
    public ActionResponse get(String index, String type, String id) {
        GetResponse getResp = (GetResponse)this.client.prepareGet(index, type, id).get();
        return new ActionResponse().succeeded(getResp.isExists()).hit(new HitWrapper(getResp.getIndex(), getResp.getType(), getResp.getId(), getResp.getSourceAsString()));
    }

    @Override
    public ActionResponse delete(String index, String type, String id) {
        DeleteResponse delResp = (DeleteResponse)this.client.prepareDelete(index, type, id).get();
        return new ActionResponse().succeeded(delResp.isFound()).hit(new HitWrapper(delResp.getIndex(), delResp.getType(), delResp.getId(), null));
    }

    @Override
    public ActionResponse index(String index, String type, String id, String data) {
        IndexResponse idxResp = (IndexResponse)this.client.prepareIndex(index, type, id).setSource(data).get();
        return new ActionResponse().succeeded(idxResp.isCreated()).hit(new HitWrapper(idxResp.getIndex(), idxResp.getType(), idxResp.getId(), null));
    }

    @Override
    public ActionResponse search(String[] indices, String[] types, String query, int size) {
        SearchRequestBuilder reqBuilder = new SearchRequestBuilder((org.elasticsearch.client.ElasticsearchClient)this.client, SearchAction.INSTANCE);
        reqBuilder.setIndices(new String[0]);
        if (indices != null) {
            reqBuilder.setIndices(indices);
        }
        if (types != null) {
            reqBuilder.setTypes(types);
        }
        if (!StringUtils.isEmpty((CharSequence)query)) {
            try {
                Map source = (Map)this.gson.fromJson(query, Map.class);
                reqBuilder.setExtraSource(source);
            }
            catch (JsonSyntaxException e) {
                reqBuilder.setQuery((QueryBuilder)QueryBuilders.queryStringQuery((String)query).analyzeWildcard(true));
            }
        }
        reqBuilder.setSize(size);
        SearchResponse searchResp = (SearchResponse)reqBuilder.get();
        ActionResponse actionResp = new ActionResponse().succeeded(true).totalHits(searchResp.getHits().getTotalHits());
        if (searchResp.getAggregations() != null) {
            this.setAggregations(searchResp.getAggregations(), actionResp);
        } else {
            for (SearchHit hit : searchResp.getHits()) {
                String src = hit.getSourceAsString();
                if (src == null) {
                    HashMap<String, List> hitFields = new HashMap<String, List>();
                    for (SearchHitField hitField : hit.getFields().values()) {
                        hitFields.put(hitField.getName(), hitField.getValues());
                    }
                    src = this.gson.toJson(hitFields);
                }
                actionResp.addHit(new HitWrapper(hit.getIndex(), hit.getType(), hit.getId(), src));
            }
        }
        return actionResp;
    }

    private void setAggregations(Aggregations aggregations, ActionResponse actionResp) {
        Aggregation agg = (Aggregation)aggregations.asList().get(0);
        if (agg instanceof InternalMetricsAggregation) {
            actionResp.addAggregation(new AggWrapper(AggWrapper.AggregationType.SIMPLE, XContentHelper.toString((ToXContent)((InternalMetricsAggregation)agg)).toString()));
        } else if (agg instanceof InternalSingleBucketAggregation) {
            actionResp.addAggregation(new AggWrapper(AggWrapper.AggregationType.SIMPLE, XContentHelper.toString((ToXContent)((InternalSingleBucketAggregation)agg)).toString()));
        } else if (agg instanceof InternalMultiBucketAggregation) {
            HashSet headerKeys = new HashSet();
            LinkedList buckets = new LinkedList();
            InternalMultiBucketAggregation multiBucketAgg = (InternalMultiBucketAggregation)agg;
            for (MultiBucketsAggregation.Bucket bucket : multiBucketAgg.getBuckets()) {
                try {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    bucket.toXContent(builder, null);
                    actionResp.addAggregation(new AggWrapper(AggWrapper.AggregationType.MULTI_BUCKETS, builder.string()));
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public String toString() {
        return "TransportBasedClient []";
    }
}

