/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.elasticsearch.client;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.elasticsearch.action.ActionException;
import org.apache.zeppelin.elasticsearch.action.ActionResponse;
import org.apache.zeppelin.elasticsearch.action.AggWrapper;
import org.apache.zeppelin.elasticsearch.action.HitWrapper;
import org.apache.zeppelin.elasticsearch.client.ElasticsearchClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpBasedClient
implements ElasticsearchClient {
    private static final String QUERY_STRING_TEMPLATE = "{ \"query\": { \"query_string\": { \"query\": \"_Q_\", \"analyze_wildcard\": \"true\" } } }";
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public HttpBasedClient(Properties props) {
        this.host = props.getProperty("elasticsearch.host");
        this.port = Integer.parseInt(props.getProperty("elasticsearch.port"));
        this.username = props.getProperty("elasticsearch.basicauth.username");
        this.password = props.getProperty("elasticsearch.basicauth.password");
    }

    private boolean isSucceeded(HttpResponse response) {
        return response.getStatus() >= 200 && response.getStatus() < 300;
    }

    private JSONObject getParentField(JSONObject parent, String[] fields) {
        JSONObject obj = parent;
        for (int i = 0; i < fields.length - 1; ++i) {
            obj = obj.optJSONObject(fields[i]);
        }
        return obj;
    }

    private JSONArray getFieldAsArray(JSONObject obj, String field) {
        String[] fields = field.split("/");
        JSONObject parent = this.getParentField(obj, fields);
        return parent.getJSONArray(fields[fields.length - 1]);
    }

    private String getFieldAsString(HttpResponse<JsonNode> response, String field) {
        return this.getFieldAsString((JsonNode)response.getBody(), field);
    }

    private String getFieldAsString(JsonNode json, String field) {
        return json.getObject().get(field).toString();
    }

    private long getFieldAsLong(HttpResponse<JsonNode> response, String field) {
        String[] fields = field.split("/");
        JSONObject obj = this.getParentField(((JsonNode)response.getBody()).getObject(), fields);
        return obj.getLong(fields[fields.length - 1]);
    }

    private String getUrl(String index, String type, String id, boolean useSearch) {
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append("http://").append(this.host).append(":").append(this.port).append("/");
            if (StringUtils.isNotEmpty((CharSequence)index)) {
                buffer.append(index);
                if (StringUtils.isNotEmpty((CharSequence)type)) {
                    buffer.append("/").append(type);
                    if (StringUtils.isNotEmpty((CharSequence)id)) {
                        if (useSearch) {
                            String encodedId = URLEncoder.encode(id, "UTF-8");
                            if (id.equals(encodedId)) {
                                buffer.append("/").append(id);
                            } else {
                                buffer.append("/_search?source=").append(URLEncoder.encode("{\"query\":{\"terms\":{\"_id\":[\"" + id + "\"]}}}", "UTF-8"));
                            }
                        } else {
                            buffer.append("/").append(id);
                        }
                    }
                }
            }
            return buffer.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new ActionException(e);
        }
    }

    private String getUrl(String[] indices, String[] types) {
        String inds = indices == null ? null : Joiner.on((String)",").join((Object[])indices);
        String typs = types == null ? null : Joiner.on((String)",").join((Object[])types);
        return this.getUrl(inds, typs, null, false);
    }

    @Override
    public ActionResponse get(String index, String type, String id) {
        ActionResponse response;
        block7: {
            response = null;
            try {
                HttpResponse result;
                boolean isSucceeded;
                GetRequest request = Unirest.get((String)this.getUrl(index, type, id, true));
                if (StringUtils.isNotEmpty((CharSequence)this.username)) {
                    request.basicAuth(this.username, this.password);
                }
                if (isSucceeded = this.isSucceeded(result = request.asString())) {
                    JsonNode body = new JsonNode((String)result.getBody());
                    if (body.getObject().has("_index")) {
                        response = new ActionResponse().succeeded(true).hit(new HitWrapper(this.getFieldAsString(body, "_index"), this.getFieldAsString(body, "_type"), this.getFieldAsString(body, "_id"), this.getFieldAsString(body, "_source")));
                    } else {
                        JSONArray hits = this.getFieldAsArray(body.getObject(), "hits/hits");
                        JSONObject hit = (JSONObject)hits.iterator().next();
                        response = new ActionResponse().succeeded(true).hit(new HitWrapper(hit.getString("_index"), hit.getString("_type"), hit.getString("_id"), hit.opt("_source").toString()));
                    }
                    break block7;
                }
                if (result.getStatus() == 404) {
                    response = new ActionResponse().succeeded(false);
                    break block7;
                }
                throw new ActionException((String)result.getBody());
            }
            catch (UnirestException e) {
                throw new ActionException(e);
            }
        }
        return response;
    }

    @Override
    public ActionResponse delete(String index, String type, String id) {
        ActionResponse response = null;
        try {
            HttpResponse result;
            boolean isSucceeded;
            HttpRequestWithBody request = Unirest.delete((String)this.getUrl(index, type, id, true));
            if (StringUtils.isNotEmpty((CharSequence)this.username)) {
                request.basicAuth(this.username, this.password);
            }
            if (!(isSucceeded = this.isSucceeded(result = request.asString()))) {
                throw new ActionException((String)result.getBody());
            }
            JsonNode body = new JsonNode((String)result.getBody());
            response = new ActionResponse().succeeded(true).hit(new HitWrapper(this.getFieldAsString(body, "_index"), this.getFieldAsString(body, "_type"), this.getFieldAsString(body, "_id"), null));
        }
        catch (UnirestException e) {
            throw new ActionException(e);
        }
        return response;
    }

    @Override
    public ActionResponse index(String index, String type, String id, String data) {
        ActionResponse response = null;
        try {
            HttpResponse result;
            boolean isSucceeded;
            HttpRequestWithBody request = null;
            request = StringUtils.isEmpty((CharSequence)id) ? Unirest.post((String)this.getUrl(index, type, id, false)) : Unirest.put((String)this.getUrl(index, type, id, false));
            request.header("Accept", "application/json").header("Content-Type", "application/json").body(data).getHttpRequest();
            if (StringUtils.isNotEmpty((CharSequence)this.username)) {
                request.basicAuth(this.username, this.password);
            }
            if (!(isSucceeded = this.isSucceeded(result = request.asJson()))) {
                throw new ActionException(((JsonNode)result.getBody()).toString());
            }
            response = new ActionResponse().succeeded(true).hit(new HitWrapper(this.getFieldAsString((HttpResponse<JsonNode>)result, "_index"), this.getFieldAsString((HttpResponse<JsonNode>)result, "_type"), this.getFieldAsString((HttpResponse<JsonNode>)result, "_id"), null));
        }
        catch (UnirestException e) {
            throw new ActionException(e);
        }
        return response;
    }

    @Override
    public ActionResponse search(String[] indices, String[] types, String query, int size) {
        ActionResponse response;
        block17: {
            response = null;
            if (!StringUtils.isEmpty((CharSequence)query)) {
                try {
                    this.gson.fromJson(query, Map.class);
                }
                catch (JsonParseException e) {
                    query = QUERY_STRING_TEMPLATE.replace("_Q_", query);
                }
            }
            try {
                HttpResponse result;
                JSONObject body;
                HttpRequestWithBody request = Unirest.post((String)(this.getUrl(indices, types) + "/_search?size=" + size)).header("Content-Type", "application/json");
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{query})) {
                    request.header("Accept", "application/json").body(query);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.username)) {
                    request.basicAuth(this.username, this.password);
                }
                JSONObject jSONObject = body = (result = request.asJson()).getBody() != null ? ((JsonNode)result.getBody()).getObject() : null;
                if (this.isSucceeded(result)) {
                    long total = this.getFieldAsLong((HttpResponse<JsonNode>)result, "hits/total");
                    response = new ActionResponse().succeeded(true).totalHits(total);
                    if (this.containsAggs((HttpResponse<JsonNode>)result)) {
                        Iterator iterator;
                        JSONObject aggregationsMap = body.getJSONObject("aggregations");
                        if (aggregationsMap == null) {
                            aggregationsMap = body.getJSONObject("aggs");
                        }
                        if ((iterator = aggregationsMap.keySet().iterator()).hasNext()) {
                            String key = (String)iterator.next();
                            JSONObject aggResult = aggregationsMap.getJSONObject(key);
                            if (aggResult.has("buckets")) {
                                Iterator buckets = aggResult.getJSONArray("buckets").iterator();
                                while (buckets.hasNext()) {
                                    response.addAggregation(new AggWrapper(AggWrapper.AggregationType.MULTI_BUCKETS, buckets.next().toString()));
                                }
                            } else {
                                response.addAggregation(new AggWrapper(AggWrapper.AggregationType.SIMPLE, aggregationsMap.toString()));
                            }
                        }
                    } else if (size > 0 && total > 0L) {
                        JSONArray hits = this.getFieldAsArray(body, "hits/hits");
                        for (JSONObject hit : hits) {
                            Object data = hit.opt("_source") != null ? hit.opt("_source") : hit.opt("fields");
                            response.addHit(new HitWrapper(hit.getString("_index"), hit.getString("_type"), hit.getString("_id"), data.toString()));
                        }
                    }
                    break block17;
                }
                throw new ActionException(body.get("error").toString());
            }
            catch (UnirestException e) {
                throw new ActionException(e);
            }
        }
        return response;
    }

    private boolean containsAggs(HttpResponse<JsonNode> result) {
        return result.getBody() != null && (((JsonNode)result.getBody()).getObject().has("aggregations") || ((JsonNode)result.getBody()).getObject().has("aggs"));
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "HttpBasedClient [host=" + this.host + ", port=" + this.port + ", username=" + this.username + "]";
    }
}

