/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.elasticsearch;

import com.github.wnameless.json.flattener.JsonFlattener;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.completer.CompletionType;
import org.apache.zeppelin.elasticsearch.action.ActionResponse;
import org.apache.zeppelin.elasticsearch.action.AggWrapper;
import org.apache.zeppelin.elasticsearch.action.HitWrapper;
import org.apache.zeppelin.elasticsearch.client.ElasticsearchClient;
import org.apache.zeppelin.elasticsearch.client.HttpBasedClient;
import org.apache.zeppelin.elasticsearch.client.TransportBasedClient;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchInterpreter
extends Interpreter {
    private static Logger logger = LoggerFactory.getLogger(ElasticsearchInterpreter.class);
    private static final String HELP = "Elasticsearch interpreter:\nGeneral format: <command> /<indices>/<types>/<id> <option> <JSON>\n  - indices: list of indices separated by commas (depends on the command)\n  - types: list of document types separated by commas (depends on the command)\nCommands:\n  - search /indices/types <query>\n    . indices and types can be omitted (at least, you have to provide '/')\n    . a query is either a JSON-formatted query, nor a lucene query\n  - size <value>\n    . defines the size of the result set (default value is in the config)\n    . if used, this command must be declared before a search command\n  - count /indices/types <query>\n    . same comments as for the search\n  - get /index/type/id\n  - delete /index/type/id\n  - index /index/type/id <json-formatted document>\n    . the id can be omitted, elasticsearch will generate one";
    protected static final List<String> COMMANDS = Arrays.asList("count", "delete", "get", "help", "index", "search");
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("\\[\\\\\"(.+)\\\\\"\\](.*)");
    public static final String ELASTICSEARCH_HOST = "elasticsearch.host";
    public static final String ELASTICSEARCH_PORT = "elasticsearch.port";
    public static final String ELASTICSEARCH_CLIENT_TYPE = "elasticsearch.client.type";
    public static final String ELASTICSEARCH_CLUSTER_NAME = "elasticsearch.cluster.name";
    public static final String ELASTICSEARCH_RESULT_SIZE = "elasticsearch.result.size";
    public static final String ELASTICSEARCH_BASIC_AUTH_USERNAME = "elasticsearch.basicauth.username";
    public static final String ELASTICSEARCH_BASIC_AUTH_PASSWORD = "elasticsearch.basicauth.password";
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private ElasticsearchClient elsClient;
    private int resultSize = 10;

    public ElasticsearchInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        logger.info("Properties: {}", (Object)this.getProperties());
        String clientType = this.getProperty(ELASTICSEARCH_CLIENT_TYPE);
        clientType = clientType == null ? null : clientType.toLowerCase();
        try {
            this.resultSize = Integer.parseInt(this.getProperty(ELASTICSEARCH_RESULT_SIZE));
        }
        catch (NumberFormatException e) {
            this.resultSize = 10;
            logger.error("Unable to parse elasticsearch.result.size : " + this.getProperty(ELASTICSEARCH_RESULT_SIZE), (Throwable)e);
        }
        try {
            if (StringUtils.isEmpty((CharSequence)clientType) || "transport".equals(clientType)) {
                this.elsClient = new TransportBasedClient(this.getProperties());
            } else if ("http".equals(clientType)) {
                this.elsClient = new HttpBasedClient(this.getProperties());
            } else {
                logger.error("Unknown type of Elasticsearch client: " + clientType);
            }
        }
        catch (IOException e) {
            logger.error("Open connection with Elasticsearch", (Throwable)e);
        }
    }

    public void close() {
        if (this.elsClient != null) {
            this.elsClient.close();
        }
    }

    public InterpreterResult interpret(String cmd, InterpreterContext interpreterContext) {
        logger.info("Run Elasticsearch command '" + cmd + "'");
        if (StringUtils.isEmpty((CharSequence)cmd) || StringUtils.isEmpty((CharSequence)cmd.trim())) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        int currentResultSize = this.resultSize;
        if (this.elsClient == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Problem with the Elasticsearch client, please check your configuration (host, port,...)");
        }
        String[] items = StringUtils.split((String)cmd.trim(), (String)" ", (int)3);
        if ("help".equalsIgnoreCase(items[0])) {
            return this.processHelp(InterpreterResult.Code.SUCCESS, null);
        }
        if ("size".equalsIgnoreCase(items[0])) {
            String[] lines = StringUtils.split((String)cmd.trim(), (String)"\n", (int)2);
            if (lines.length < 2) {
                return this.processHelp(InterpreterResult.Code.ERROR, "Size cmd must be followed by a search");
            }
            String[] sizeLine = StringUtils.split((String)lines[0], (String)" ", (int)2);
            if (sizeLine.length != 2) {
                return this.processHelp(InterpreterResult.Code.ERROR, "Right format is : size <value>");
            }
            currentResultSize = Integer.parseInt(sizeLine[1]);
            items = StringUtils.split((String)lines[1].trim(), (String)" ", (int)3);
        }
        if (items.length < 2) {
            return this.processHelp(InterpreterResult.Code.ERROR, "Arguments missing");
        }
        String method = items[0];
        String url = items[1];
        String data = items.length > 2 ? items[2].trim() : null;
        String[] urlItems = StringUtils.split((String)url.trim(), (String)"/");
        try {
            if ("get".equalsIgnoreCase(method)) {
                return this.processGet(urlItems, interpreterContext);
            }
            if ("count".equalsIgnoreCase(method)) {
                return this.processCount(urlItems, data, interpreterContext);
            }
            if ("search".equalsIgnoreCase(method)) {
                return this.processSearch(urlItems, data, currentResultSize, interpreterContext);
            }
            if ("index".equalsIgnoreCase(method)) {
                return this.processIndex(urlItems, data);
            }
            if ("delete".equalsIgnoreCase(method)) {
                return this.processDelete(urlItems);
            }
            return this.processHelp(InterpreterResult.Code.ERROR, "Unknown command");
        }
        catch (Exception e) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Error : " + e.getMessage());
        }
    }

    public void cancel(InterpreterContext interpreterContext) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext interpreterContext) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String s, int i, InterpreterContext interpreterContext) {
        ArrayList<InterpreterCompletion> suggestions = new ArrayList<InterpreterCompletion>();
        for (String cmd : COMMANDS) {
            if (!cmd.toLowerCase().contains(s)) continue;
            suggestions.add(new InterpreterCompletion(cmd, cmd, CompletionType.command.name()));
        }
        return suggestions;
    }

    private void addAngularObject(InterpreterContext interpreterContext, String prefix, Object obj) {
        interpreterContext.getAngularObjectRegistry().add(prefix + "_" + interpreterContext.getParagraphId().replace("-", "_"), obj, null, null);
    }

    private String[] getIndexTypeId(String[] urlItems) {
        if (urlItems.length < 3) {
            return null;
        }
        String index = urlItems[0];
        String type = urlItems[1];
        String id = StringUtils.join((Object[])Arrays.copyOfRange(urlItems, 2, urlItems.length), (char)'/');
        if (StringUtils.isEmpty((CharSequence)index) || StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return new String[]{index, type, id};
    }

    private InterpreterResult processHelp(InterpreterResult.Code code, String additionalMessage) {
        StringBuffer buffer = new StringBuffer();
        if (additionalMessage != null) {
            buffer.append(additionalMessage).append("\n");
        }
        buffer.append(HELP).append("\n");
        return new InterpreterResult(code, InterpreterResult.Type.TEXT, buffer.toString());
    }

    private InterpreterResult processGet(String[] urlItems, InterpreterContext interpreterContext) {
        String[] indexTypeId = this.getIndexTypeId(urlItems);
        if (indexTypeId == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Bad URL (it should be /index/type/id)");
        }
        ActionResponse response = this.elsClient.get(indexTypeId[0], indexTypeId[1], indexTypeId[2]);
        if (response.isSucceeded()) {
            JsonObject json = response.getHit().getSourceAsJsonObject();
            String jsonStr = this.gson.toJson((JsonElement)json);
            this.addAngularObject(interpreterContext, "get", json);
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, jsonStr);
        }
        return new InterpreterResult(InterpreterResult.Code.ERROR, "Document not found");
    }

    private InterpreterResult processCount(String[] urlItems, String data, InterpreterContext interpreterContext) {
        if (urlItems.length > 2) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Bad URL (it should be /index1,index2,.../type1,type2,...)");
        }
        ActionResponse response = this.searchData(urlItems, data, 0);
        this.addAngularObject(interpreterContext, "count", response.getTotalHits());
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, "" + response.getTotalHits());
    }

    private InterpreterResult processSearch(String[] urlItems, String data, int size, InterpreterContext interpreterContext) {
        if (urlItems.length > 2) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Bad URL (it should be /index1,index2,.../type1,type2,...)");
        }
        ActionResponse response = this.searchData(urlItems, data, size);
        this.addAngularObject(interpreterContext, "search", response.getAggregations() != null && response.getAggregations().size() > 0 ? response.getAggregations() : response.getHits());
        return this.buildResponseMessage(response);
    }

    private InterpreterResult processIndex(String[] urlItems, String data) {
        if (urlItems.length < 2 || urlItems.length > 3) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Bad URL (it should be /index/type or /index/type/id)");
        }
        ActionResponse response = this.elsClient.index(urlItems[0], urlItems[1], urlItems.length == 2 ? null : urlItems[2], data);
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, response.getHit().getId());
    }

    private InterpreterResult processDelete(String[] urlItems) {
        String[] indexTypeId = this.getIndexTypeId(urlItems);
        if (indexTypeId == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Bad URL (it should be /index/type/id)");
        }
        ActionResponse response = this.elsClient.delete(indexTypeId[0], indexTypeId[1], indexTypeId[2]);
        if (response.isSucceeded()) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, response.getHit().getId());
        }
        return new InterpreterResult(InterpreterResult.Code.ERROR, "Document not found");
    }

    private ActionResponse searchData(String[] urlItems, String query, int size) {
        String[] indices = null;
        String[] types = null;
        if (urlItems.length >= 1) {
            indices = StringUtils.split((String)urlItems[0], (String)",");
        }
        if (urlItems.length > 1) {
            types = StringUtils.split((String)urlItems[1], (String)",");
        }
        return this.elsClient.search(indices, types, query, size);
    }

    private InterpreterResult buildAggResponseMessage(Aggregations aggregations) {
        Aggregation agg = (Aggregation)aggregations.asList().get(0);
        InterpreterResult.Type resType = InterpreterResult.Type.TEXT;
        String resMsg = "";
        if (agg instanceof InternalMetricsAggregation) {
            resMsg = XContentHelper.toString((ToXContent)((InternalMetricsAggregation)agg)).toString();
        } else if (agg instanceof InternalSingleBucketAggregation) {
            resMsg = XContentHelper.toString((ToXContent)((InternalSingleBucketAggregation)agg)).toString();
        } else if (agg instanceof InternalMultiBucketAggregation) {
            HashSet headerKeys = new HashSet();
            LinkedList<Map> buckets = new LinkedList<Map>();
            InternalMultiBucketAggregation multiBucketAgg = (InternalMultiBucketAggregation)agg;
            for (MultiBucketsAggregation.Bucket bucket : multiBucketAgg.getBuckets()) {
                try {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    bucket.toXContent(builder, null);
                    Map bucketMap = JsonFlattener.flattenAsMap((String)builder.string());
                    headerKeys.addAll(bucketMap.keySet());
                    buckets.add(bucketMap);
                }
                catch (IOException e) {
                    logger.error("Processing bucket: " + e.getMessage(), (Throwable)e);
                }
            }
            StringBuffer buffer = new StringBuffer();
            String[] keys = headerKeys.toArray(new String[0]);
            for (String key : keys) {
                buffer.append("\t" + key);
            }
            buffer.deleteCharAt(0);
            for (Map bucket : buckets) {
                buffer.append("\n");
                for (String key : keys) {
                    buffer.append(bucket.get(key)).append("\t");
                }
                buffer.deleteCharAt(buffer.length() - 1);
            }
            resType = InterpreterResult.Type.TABLE;
            resMsg = buffer.toString();
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, resType, resMsg);
    }

    private InterpreterResult buildAggResponseMessage(List<AggWrapper> aggregations) {
        InterpreterResult.Type resType = InterpreterResult.Type.TABLE;
        String resMsg = "";
        HashSet headerKeys = new HashSet();
        LinkedList<Map> buckets = new LinkedList<Map>();
        for (AggWrapper aggregation : aggregations) {
            Map bucketMap = JsonFlattener.flattenAsMap((String)aggregation.getResult());
            headerKeys.addAll(bucketMap.keySet());
            buckets.add(bucketMap);
        }
        StringBuffer buffer = new StringBuffer();
        String[] keys = headerKeys.toArray(new String[0]);
        for (String key : keys) {
            buffer.append("\t" + key);
        }
        buffer.deleteCharAt(0);
        for (Map bucket : buckets) {
            buffer.append("\n");
            for (String key : keys) {
                buffer.append(bucket.get(key)).append("\t");
            }
            buffer.deleteCharAt(buffer.length() - 1);
        }
        resMsg = buffer.toString();
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, resType, resMsg);
    }

    private String buildSearchHitsResponseMessage(ActionResponse response) {
        if (response.getHits() == null || response.getHits().size() == 0) {
            return "";
        }
        LinkedList flattenHits = new LinkedList();
        TreeSet<String> keys = new TreeSet<String>();
        for (HitWrapper hit : response.getHits()) {
            String string = hit.getSourceAsString();
            Map flattenJsonMap = JsonFlattener.flattenAsMap((String)string);
            HashMap flattenMap = new HashMap();
            for (String fieldName : flattenJsonMap.keySet()) {
                Matcher fieldNameMatcher = FIELD_NAME_PATTERN.matcher(fieldName);
                if (fieldNameMatcher.matches()) {
                    flattenMap.put(fieldNameMatcher.group(1) + fieldNameMatcher.group(2), flattenJsonMap.get(fieldName));
                    continue;
                }
                flattenMap.put(fieldName, flattenJsonMap.get(fieldName));
            }
            flattenHits.add(flattenMap);
            for (String key : flattenMap.keySet()) {
                keys.add(key);
            }
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : keys) {
            buffer.append(string).append('\t');
        }
        buffer.replace(buffer.lastIndexOf("\t"), buffer.lastIndexOf("\t") + 1, "\n");
        for (Map map : flattenHits) {
            for (String key : keys) {
                Object val = map.get(key);
                if (val != null) {
                    buffer.append(val);
                }
                buffer.append('\t');
            }
            buffer.replace(buffer.lastIndexOf("\t"), buffer.lastIndexOf("\t") + 1, "\n");
        }
        return buffer.toString();
    }

    private InterpreterResult buildResponseMessage(ActionResponse response) {
        List<AggWrapper> aggregations = response.getAggregations();
        if (aggregations != null && aggregations.size() > 0) {
            return this.buildAggResponseMessage(aggregations);
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TABLE, this.buildSearchHitsResponseMessage(response));
    }
}

