/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.ParagraphResult;
import org.apache.zeppelin.client.Status;
import org.apache.zeppelin.client.ZeppelinClient;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.client.websocket.StatementMessageHandler;
import org.apache.zeppelin.client.websocket.ZeppelinWebSocketClient;
import org.apache.zeppelin.common.Message;
import org.apache.zeppelin.common.SessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZSession.class);
    private ZeppelinClient zeppelinClient;
    private String interpreter;
    private Map<String, String> intpProperties;
    private int maxStatement;
    private SessionInfo sessionInfo;
    private ZeppelinWebSocketClient webSocketClient;

    public ZSession(ClientConfig clientConfig, String interpreter) throws Exception {
        this(clientConfig, interpreter, new HashMap<String, String>(), 100);
    }

    public ZSession(ClientConfig clientConfig, String interpreter, Map<String, String> intpProperties, int maxStatement) throws Exception {
        this.zeppelinClient = new ZeppelinClient(clientConfig);
        this.interpreter = interpreter;
        this.intpProperties = intpProperties;
        this.maxStatement = maxStatement;
    }

    private ZSession(ClientConfig clientConfig, String interpreter, String sessionId) throws Exception {
        this.zeppelinClient = new ZeppelinClient(clientConfig);
        this.interpreter = interpreter;
        this.sessionInfo = new SessionInfo(sessionId);
    }

    public void login(String userName, String password) throws Exception {
        this.zeppelinClient.login(userName, password);
    }

    public void start() throws Exception {
        this.start(null);
    }

    public void start(MessageHandler messageHandler) throws Exception {
        this.sessionInfo = this.zeppelinClient.newSession(this.interpreter);
        StringBuilder builder = new StringBuilder("%" + this.interpreter + ".conf\n");
        if (this.intpProperties != null) {
            for (Map.Entry<String, String> entry : this.intpProperties.entrySet()) {
                builder.append(entry.getKey() + " " + entry.getValue() + "\n");
            }
        }
        String paragraphId = this.zeppelinClient.addParagraph(this.getNoteId(), "Session Configuration", builder.toString());
        ParagraphResult paragraphResult = this.zeppelinClient.executeParagraph(this.getNoteId(), paragraphId, this.getSessionId());
        if (paragraphResult.getStatus() != Status.FINISHED) {
            throw new Exception("Fail to configure session, " + paragraphResult.getResultInText());
        }
        paragraphId = this.zeppelinClient.addParagraph(this.getNoteId(), "Session Init", "%" + this.interpreter + "(init=true)");
        paragraphResult = this.zeppelinClient.executeParagraph(this.getNoteId(), paragraphId, this.getSessionId());
        if (paragraphResult.getStatus() != Status.FINISHED) {
            throw new Exception("Fail to init session, " + paragraphResult.getResultInText());
        }
        this.sessionInfo = this.zeppelinClient.getSession(this.getSessionId());
        if (messageHandler != null) {
            this.webSocketClient = new ZeppelinWebSocketClient(messageHandler);
            this.webSocketClient.connect(this.zeppelinClient.getClientConfig().getZeppelinRestUrl().replace("https", "ws").replace("http", "ws") + "/ws");
            Message msg = new Message(Message.OP.GET_NOTE);
            msg.put("id", (Object)this.getNoteId());
            this.webSocketClient.send(msg);
        }
    }

    public void stop() throws Exception {
        if (this.getSessionId() != null) {
            this.zeppelinClient.stopSession(this.getSessionId());
        }
        if (this.webSocketClient != null) {
            this.webSocketClient.stop();
        }
    }

    public static ZSession createFromExistingSession(ClientConfig clientConfig, String interpreter, String sessionId) throws Exception {
        return ZSession.createFromExistingSession(clientConfig, interpreter, sessionId, null);
    }

    public static ZSession createFromExistingSession(ClientConfig clientConfig, String interpreter, String sessionId, MessageHandler messageHandler) throws Exception {
        ZSession session = new ZSession(clientConfig, interpreter, sessionId);
        session.reconnect(messageHandler);
        return session;
    }

    private void reconnect(MessageHandler messageHandler) throws Exception {
        this.sessionInfo = this.zeppelinClient.getSession(this.getSessionId());
        if (!this.sessionInfo.getState().equalsIgnoreCase("Running")) {
            throw new Exception("Session " + this.getSessionId() + " is not running, state: " + this.sessionInfo.getState());
        }
        if (messageHandler != null) {
            this.webSocketClient = new ZeppelinWebSocketClient(messageHandler);
            this.webSocketClient.connect(this.zeppelinClient.getClientConfig().getZeppelinRestUrl().replace("https", "ws").replace("http", "ws") + "/ws");
            Message msg = new Message(Message.OP.GET_NOTE);
            msg.put("id", (Object)this.getNoteId());
            this.webSocketClient.send(msg);
        }
    }

    public ExecuteResult execute(String code) throws Exception {
        return this.execute("", code);
    }

    public ExecuteResult execute(String code, Map<String, String> localProperties) throws Exception {
        return this.execute("", localProperties, code);
    }

    public ExecuteResult execute(String code, StatementMessageHandler messageHandler) throws Exception {
        return this.execute("", code, messageHandler);
    }

    public ExecuteResult execute(String subInterpreter, String code) throws Exception {
        return this.execute(subInterpreter, new HashMap<String, String>(), code);
    }

    public ExecuteResult execute(String subInterpreter, String code, StatementMessageHandler messageHandler) throws Exception {
        return this.execute(subInterpreter, new HashMap<String, String>(), code, messageHandler);
    }

    public ExecuteResult execute(String subInterpreter, Map<String, String> localProperties, String code) throws Exception {
        return this.execute(subInterpreter, localProperties, code, null);
    }

    public ExecuteResult execute(String subInterpreter, Map<String, String> localProperties, String code, StatementMessageHandler messageHandler) throws Exception {
        StringBuilder builder = new StringBuilder("%" + this.interpreter);
        if (!StringUtils.isBlank((CharSequence)subInterpreter)) {
            builder.append("." + subInterpreter);
        }
        if (localProperties != null && !localProperties.isEmpty()) {
            builder.append("(");
            List propertyString = localProperties.entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\"=\"" + (String)entry.getValue() + "\"").collect(Collectors.toList());
            builder.append(StringUtils.join(propertyString, (String)","));
            builder.append(")");
        }
        builder.append(" " + code);
        String text = builder.toString();
        String nextParagraphId = this.zeppelinClient.nextSessionParagraph(this.getNoteId(), this.maxStatement);
        this.zeppelinClient.updateParagraph(this.getNoteId(), nextParagraphId, "", text);
        if (messageHandler != null) {
            this.webSocketClient.addStatementMessageHandler(nextParagraphId, messageHandler);
        }
        ParagraphResult paragraphResult = this.zeppelinClient.executeParagraph(this.getNoteId(), nextParagraphId, this.getSessionId());
        return new ExecuteResult(paragraphResult);
    }

    public ExecuteResult submit(String code) throws Exception {
        return this.submit("", code);
    }

    public ExecuteResult submit(String code, StatementMessageHandler messageHandler) throws Exception {
        return this.submit("", code, messageHandler);
    }

    public ExecuteResult submit(String subInterpreter, String code) throws Exception {
        return this.submit(subInterpreter, new HashMap<String, String>(), code);
    }

    public ExecuteResult submit(String subInterpreter, String code, StatementMessageHandler messageHandler) throws Exception {
        return this.submit(subInterpreter, new HashMap<String, String>(), code, messageHandler);
    }

    public ExecuteResult submit(String subInterpreter, Map<String, String> localProperties, String code) throws Exception {
        return this.submit(subInterpreter, localProperties, code, null);
    }

    public ExecuteResult submit(String subInterpreter, Map<String, String> localProperties, String code, StatementMessageHandler messageHandler) throws Exception {
        StringBuilder builder = new StringBuilder("%" + this.interpreter);
        if (!StringUtils.isBlank((CharSequence)subInterpreter)) {
            builder.append("." + subInterpreter);
        }
        if (localProperties != null && !localProperties.isEmpty()) {
            builder.append("(");
            List propertyString = localProperties.entrySet().stream().map(entry -> (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"").collect(Collectors.toList());
            builder.append(StringUtils.join(propertyString, (String)","));
            builder.append(")");
        }
        builder.append(" " + code);
        String text = builder.toString();
        String nextParagraphId = this.zeppelinClient.nextSessionParagraph(this.getNoteId(), this.maxStatement);
        this.zeppelinClient.updateParagraph(this.getNoteId(), nextParagraphId, "", text);
        if (messageHandler != null) {
            this.webSocketClient.addStatementMessageHandler(nextParagraphId, messageHandler);
        }
        ParagraphResult paragraphResult = this.zeppelinClient.submitParagraph(this.getNoteId(), nextParagraphId, this.getSessionId());
        return new ExecuteResult(paragraphResult);
    }

    public void cancel(String statementId) throws Exception {
        this.zeppelinClient.cancelParagraph(this.getNoteId(), statementId);
    }

    public ExecuteResult queryStatement(String statementId) throws Exception {
        ParagraphResult paragraphResult = this.zeppelinClient.queryParagraphResult(this.getNoteId(), statementId);
        return new ExecuteResult(paragraphResult);
    }

    public ExecuteResult waitUntilFinished(String statementId) throws Exception {
        ParagraphResult paragraphResult = this.zeppelinClient.waitUtilParagraphFinish(this.getNoteId(), statementId);
        return new ExecuteResult(paragraphResult);
    }

    public ExecuteResult waitUntilRunning(String statementId) throws Exception {
        ParagraphResult paragraphResult = this.zeppelinClient.waitUtilParagraphRunning(this.getNoteId(), statementId);
        return new ExecuteResult(paragraphResult);
    }

    public String getNoteId() {
        if (this.sessionInfo != null) {
            return this.sessionInfo.getNoteId();
        }
        return null;
    }

    public String getWeburl() {
        if (this.sessionInfo != null) {
            return this.sessionInfo.getWeburl();
        }
        return null;
    }

    public String getSessionId() {
        if (this.sessionInfo != null) {
            return this.sessionInfo.getSessionId();
        }
        return null;
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public ZeppelinClient getZeppelinClient() {
        return this.zeppelinClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) throws Exception {
        ClientConfig clientConfig = new ClientConfig("http://localhost:8080", 1000L);
        ZSession sparkSession = ZSession.createFromExistingSession(clientConfig, "hive", "hive_1598418780469");
        ExecuteResult executeResult = sparkSession.execute("show databases");
        System.out.println(executeResult);
    }

    public static class Builder {
        private ClientConfig clientConfig;
        private String interpreter;
        private Map<String, String> intpProperties;
        private int maxStatement = 100;

        public Builder setClientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder setInterpreter(String interpreter) {
            this.interpreter = interpreter;
            return this;
        }

        public Builder setIntpProperties(Map<String, String> intpProperties) {
            this.intpProperties = intpProperties;
            return this;
        }

        public Builder setMaxStatement(int maxStatement) {
            this.maxStatement = maxStatement;
            return this;
        }

        public ZSession build() throws Exception {
            return new ZSession(this.clientConfig, this.interpreter, this.intpProperties, this.maxStatement);
        }
    }
}

