/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client;

import org.apache.commons.lang3.StringUtils;

public class ClientConfig {
    private String zeppelinRestUrl;
    private long queryInterval;
    private String knoxSSOUrl;

    public ClientConfig(String zeppelinRestUrl) {
        this(zeppelinRestUrl, 1000L);
    }

    public ClientConfig(String zeppelinRestUrl, long queryInterval) {
        this(zeppelinRestUrl, queryInterval, null);
    }

    public ClientConfig(String zeppelinRestUrl, long queryInterval, String knoxSSOUrl) {
        this.zeppelinRestUrl = this.removeTrailingSlash(zeppelinRestUrl);
        this.queryInterval = queryInterval;
        this.knoxSSOUrl = knoxSSOUrl;
    }

    private String removeTrailingSlash(String zeppelinRestUrl) {
        if (zeppelinRestUrl.endsWith("/")) {
            return zeppelinRestUrl.substring(0, zeppelinRestUrl.length() - 1);
        }
        return zeppelinRestUrl;
    }

    public String getZeppelinRestUrl() {
        return this.zeppelinRestUrl;
    }

    public long getQueryInterval() {
        return this.queryInterval;
    }

    public boolean isUseKnox() {
        return StringUtils.isNotBlank((CharSequence)this.knoxSSOUrl);
    }

    public String getKnoxSSOUrl() {
        return this.knoxSSOUrl;
    }
}

