/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.examples;

import java.util.HashMap;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.ZSession;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.client.websocket.SimpleMessageHandler;

public class SparkAdvancedExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZSession session = null;
        try {
            ClientConfig clientConfig = new ClientConfig("http://localhost:8080");
            HashMap<String, String> intpProperties = new HashMap<String, String>();
            intpProperties.put("spark.master", "local[*]");
            session = ZSession.builder().setClientConfig(clientConfig).setInterpreter("spark").setIntpProperties(intpProperties).build();
            session.start((MessageHandler)new SimpleMessageHandler());
            System.out.println("Spark Web UI: " + session.getWeburl());
            String code = "sc.range(1,10).map(e=> {Thread.sleep(2000); e}).sum()";
            System.out.println("Submit code: " + code);
            ExecuteResult result = session.submit(code);
            System.out.println("Job status: " + result.getStatus());
            while (!result.getStatus().isCompleted()) {
                result = session.queryStatement(result.getStatementId());
                System.out.println("Job status: " + result.getStatus() + ", progress: " + result.getProgress());
                Thread.sleep(1000L);
            }
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("Submit code: " + code);
            result = session.submit("sc.range(1,10).map(e=> {Thread.sleep(2000); e}).sum()");
            System.out.println("Job status: " + result.getStatus());
            result = session.waitUntilFinished(result.getStatementId());
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("Submit code: " + code);
            result = session.submit("sc.range(1,10).map(e=> {Thread.sleep(2000); e}).sum()");
            System.out.println("Job status: " + result.getStatus());
            session.waitUntilRunning(result.getStatementId());
            System.out.println("Try to cancel statement: " + result.getStatementId());
            session.cancel(result.getStatementId());
            result = session.waitUntilFinished(result.getStatementId());
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("-----------------------------------------------------------------------------");
            code = "for(i <- 1 to 10) {\n   Thread.sleep(1000)\n   println(i)\n}";
            System.out.println("Submit code: " + code);
            result = session.execute(code);
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                try {
                    session.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

