/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.examples;

import java.util.HashMap;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.ZSession;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.client.websocket.SimpleMessageHandler;

public class RExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZSession session = null;
        try {
            ClientConfig clientConfig = new ClientConfig("http://localhost:8080");
            HashMap intpProperties = new HashMap();
            session = ZSession.builder().setClientConfig(clientConfig).setInterpreter("r").setIntpProperties(intpProperties).build();
            session.start((MessageHandler)new SimpleMessageHandler());
            ExecuteResult result = session.execute("bare <- c(1, 2.5, 4)\nprint(bare)");
            System.out.println(((Result)result.getResults().get(0)).getData());
            result = session.execute("1/0");
            System.out.println("Result status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ir", "pairs(iris)");
            System.out.println("R plotting result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ir", "library(ggplot2)\nggplot(mpg, aes(displ, hwy, colour = class)) + \n  geom_point()");
            System.out.println("ggplot2 plotting result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ir", "library(googleVis)\ndf=data.frame(country=c(\"US\", \"GB\", \"BR\"), \n              val1=c(10,13,14), \n              val2=c(23,12,32))\nBar <- gvisBarChart(df)\nprint(Bar, tag = 'chart')");
            System.out.println("googlevis plotting result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                try {
                    session.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

