/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.examples;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.ZSession;

public class FlinkExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZSession session = null;
        try {
            ClientConfig clientConfig = new ClientConfig("http://localhost:8080");
            HashMap intpProperties = new HashMap();
            session = ZSession.builder().setClientConfig(clientConfig).setInterpreter("flink").setIntpProperties(intpProperties).build();
            session.start();
            System.out.println("Flink Web UI: " + session.getWeburl());
            ExecuteResult result = session.execute("benv.fromElements(1,2,3).print()");
            System.out.println("Result: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("val data = benv.fromElements(1,2,3).map(e=>(e, e * 2))\ndata.print()\nz.show(data)");
            System.out.println("Result 1: type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("Result 2: type: " + ((Result)result.getResults().get(1)).getType() + ", data: " + ((Result)result.getResults().get(1)).getData());
            System.out.println("Flink Job Urls:\n" + StringUtils.join((Iterable)result.getJobUrls(), (String)"\n"));
            result = session.execute("1/0");
            System.out.println("Result status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("pyflink", "type(b_env)");
            System.out.println("benv: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ipyflink", "%matplotlib inline\nimport matplotlib.pyplot as plt\nplt.plot([1,2,3,4])\nplt.ylabel('some numbers')\nplt.show()");
            System.out.println("Matplotlib result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ssql", "show tables");
            System.out.println("Flink tables: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("bsql", "select * from unknown_table");
            System.out.println("Result status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                try {
                    session.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

