/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.examples;

import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.ZSession;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.client.websocket.SimpleMessageHandler;

public class FlinkAdvancedExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZSession session = null;
        try {
            ClientConfig clientConfig = new ClientConfig("http://localhost:8080");
            HashMap intpProperties = new HashMap();
            session = ZSession.builder().setClientConfig(clientConfig).setInterpreter("flink").setIntpProperties(intpProperties).build();
            session.start((MessageHandler)new SimpleMessageHandler());
            System.out.println("Flink Web UI: " + session.getWeburl());
            String code = "benv.fromElements(1,2,3,4,5,6,7,8,9,10).map(e=> {Thread.sleep(1000); e}).print()";
            System.out.println("Submit code: " + code);
            ExecuteResult result = session.submit(code);
            System.out.println("Job status: " + result.getStatus());
            while (!result.getStatus().isCompleted()) {
                result = session.queryStatement(result.getStatementId());
                System.out.println("Job status: " + result.getStatus() + ", progress: " + result.getProgress());
                Thread.sleep(1000L);
            }
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("Submit code: " + code);
            result = session.submit("benv.fromElements(1,2,3,4,5,6,7,8,9,10).map(e=> {Thread.sleep(1000); e}).print()");
            System.out.println("Job status: " + result.getStatus());
            result = session.waitUntilFinished(result.getStatementId());
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("-----------------------------------------------------------------------------");
            code = "for(i <- 1 to 10) {\n   Thread.sleep(1000)\n   println(i)\n}";
            System.out.println("Submit code: " + code);
            result = session.execute(code);
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("-----------------------------------------------------------------------------");
            String initCode = IOUtils.toString((URL)FlinkAdvancedExample.class.getResource("/init_stream.scala"));
            result = session.execute(initCode);
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            HashMap<String, String> localProperties = new HashMap<String, String>();
            localProperties.put("type", "update");
            result = session.submit("ssql", localProperties, "select url, count(1) as pv from log group by url");
            session.waitUntilFinished(result.getStatementId());
            result = session.submit("ssql", localProperties, "select url, count(1) as pv from log group by url");
            session.waitUntilRunning(result.getStatementId());
            Thread.sleep(10000L);
            System.out.println("Try to cancel statement: " + result.getStatementId());
            session.cancel(result.getStatementId());
            session.waitUntilFinished(result.getStatementId());
            System.out.println("Job status: " + result.getStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                try {
                    session.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

