/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.examples;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.ZSession;

public class SparkExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZSession session = null;
        try {
            ClientConfig clientConfig = new ClientConfig("http://localhost:8080");
            HashMap<String, String> intpProperties = new HashMap<String, String>();
            intpProperties.put("spark.master", "local[*]");
            session = ZSession.builder().setClientConfig(clientConfig).setInterpreter("spark").setIntpProperties(intpProperties).build();
            session.start();
            System.out.println("Spark Web UI: " + session.getWeburl());
            ExecuteResult result = session.execute("println(sc.version)");
            System.out.println("Spark Version: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("println(sc.version)\nval df = spark.createDataFrame(Seq((1,\"a\"), (2,\"b\")))\nz.show(df)");
            System.out.println("Result 1: type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            System.out.println("Result 2: type: " + ((Result)result.getResults().get(1)).getType() + ", data: " + ((Result)result.getResults().get(1)).getData());
            System.out.println("Spark Job Urls:\n" + StringUtils.join((Iterable)result.getJobUrls(), (String)"\n"));
            result = session.execute("1/0");
            System.out.println("Result status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("pyspark", "df = spark.createDataFrame([(1,'a'),(2,'b')])\ndf.registerTempTable('df')\ndf.show()");
            System.out.println("PySpark dataframe: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ipyspark", "%matplotlib inline\nimport matplotlib.pyplot as plt\nplt.plot([1,2,3,4])\nplt.ylabel('some numbers')\nplt.show()");
            System.out.println("Matplotlib result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("r", "df <- as.DataFrame(faithful)\nhead(df)");
            System.out.println("Sparkr dataframe: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("sql", "select * from df");
            System.out.println("Spark Sql dataframe: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("sql", "select * from unknown_table");
            System.out.println("Result status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                try {
                    session.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

