/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.examples;

import java.util.HashMap;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.ZSession;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.client.websocket.SimpleMessageHandler;

public class PythonExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZSession session = null;
        try {
            ClientConfig clientConfig = new ClientConfig("http://localhost:8080");
            HashMap intpProperties = new HashMap();
            session = ZSession.builder().setClientConfig(clientConfig).setInterpreter("python").setIntpProperties(intpProperties).build();
            session.start((MessageHandler)new SimpleMessageHandler());
            ExecuteResult result = session.execute("print('hello world')");
            System.out.println(((Result)result.getResults().get(0)).getData());
            result = session.execute("print('hello world')\nprint('hello world2')");
            System.out.println(((Result)result.getResults().get(0)).getData());
            result = session.execute("1/0");
            System.out.println("Result status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ipython", "%matplotlib inline\nimport matplotlib.pyplot as plt\nplt.plot([1,2,3,4])\nplt.ylabel('some numbers')\nplt.show()");
            System.out.println("Matplotlib result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("ipython", "import pandas as pd\ndf = pd.DataFrame({'name':['a','b','c'], 'count':[12,24,18]})\nz.show(df)");
            System.out.println("Pandas dataframe result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
            result = session.execute("import time\nfor i in range(1,10):\n    print(i)\n    time.sleep(1)");
            System.out.println("Python streaming result, type: " + ((Result)result.getResults().get(0)).getType() + ", data: " + ((Result)result.getResults().get(0)).getData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                try {
                    session.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

