/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.examples;

import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ExecuteResult;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.ZSession;
import org.apache.zeppelin.client.examples.FlinkAdvancedExample;
import org.apache.zeppelin.client.websocket.CompositeMessageHandler;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.client.websocket.StatementMessageHandler;

public class FlinkAdvancedExample2 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZSession session = null;
        try {
            ClientConfig clientConfig = new ClientConfig("http://localhost:8080");
            HashMap intpProperties = new HashMap();
            session = ZSession.builder().setClientConfig(clientConfig).setInterpreter("flink").setIntpProperties(intpProperties).build();
            session.start((MessageHandler)new CompositeMessageHandler());
            System.out.println("Flink Web UI: " + session.getWeburl());
            System.out.println("-----------------------------------------------------------------------------");
            String initCode = IOUtils.toString((URL)FlinkAdvancedExample.class.getResource("/init_stream.scala"));
            ExecuteResult result = session.execute(initCode);
            System.out.println("Job status: " + result.getStatus() + ", data: " + ((Result)result.getResults().get(0)).getData());
            HashMap<String, String> localProperties = new HashMap<String, String>();
            localProperties.put("type", "update");
            result = session.submit("ssql", localProperties, "select url, count(1) as pv from log group by url", (StatementMessageHandler)new MyStatementMessageHandler1());
            session.waitUntilFinished(result.getStatementId());
            result = session.submit("ssql", localProperties, "select upper(url), count(1) as pv from log group by url", (StatementMessageHandler)new MyStatementMessageHandler2());
            session.waitUntilFinished(result.getStatementId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                try {
                    session.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class MyStatementMessageHandler2
    implements StatementMessageHandler {
        public void onStatementAppendOutput(String statementId, int index, String output) {
            System.out.println("MyStatementMessageHandler2, append output: " + output);
        }

        public void onStatementUpdateOutput(String statementId, int index, String type, String output) {
            System.out.println("MyStatementMessageHandler2, update output: " + output);
        }
    }

    public static class MyStatementMessageHandler1
    implements StatementMessageHandler {
        public void onStatementAppendOutput(String statementId, int index, String output) {
            System.out.println("MyStatementMessageHandler1, append output: " + output);
        }

        public void onStatementUpdateOutput(String statementId, int index, String type, String output) {
            System.out.println("MyStatementMessageHandler1, update output: " + output);
        }
    }
}

