/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.StructType;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.apache.zeppelin.interpreter.SingleRowInterpreterResult;
import org.apache.zeppelin.spark.SparkShims;
import org.apache.zeppelin.tabledata.TableDataUtils;

public class Spark3Shims
extends SparkShims {
    private SparkSession sparkSession;

    public Spark3Shims(Properties properties, Object entryPoint) {
        super(properties);
        this.sparkSession = (SparkSession)entryPoint;
    }

    public void setupSparkListener(final String master, final String sparkWebUrl, final InterpreterContext context) {
        final SparkContext sc = SparkContext.getOrCreate();
        sc.addSparkListener((SparkListenerInterface)new SparkListener(){

            public void onJobStart(SparkListenerJobStart jobStart) {
                if (sc.getConf().getBoolean("spark.ui.enabled", true) && !Boolean.parseBoolean(Spark3Shims.this.properties.getProperty("zeppelin.spark.ui.hidden", "false"))) {
                    Spark3Shims.this.buildSparkJobUrl(master, sparkWebUrl, jobStart.jobId(), jobStart.properties(), context);
                }
            }
        });
    }

    public String showDataFrame(Object obj, int maxResult, InterpreterContext context) {
        if (obj instanceof Dataset) {
            boolean isLargerThanMaxResult;
            Dataset df = ((Dataset)obj).toDF();
            Object[] columns = df.columns();
            if (columns.length == 0) {
                return "";
            }
            List rows = df.takeAsList(maxResult + 1);
            String template = (String)context.getLocalProperties().get("template");
            if (!StringUtils.isBlank((String)template)) {
                if (rows.size() >= 1) {
                    return new SingleRowInterpreterResult(this.sparkRowToList((Row)rows.get(0)), template, context).toHtml();
                }
                return "";
            }
            StringBuilder msg = new StringBuilder();
            msg.append("%table ");
            msg.append(StringUtils.join((Collection)TableDataUtils.normalizeColumns((Object[])columns), (String)"\t"));
            msg.append("\n");
            boolean bl = isLargerThanMaxResult = rows.size() > maxResult;
            if (isLargerThanMaxResult) {
                rows = rows.subList(0, maxResult);
            }
            for (Row row : rows) {
                for (int i = 0; i < row.size(); ++i) {
                    msg.append(TableDataUtils.normalizeColumn((Object)row.get(i)));
                    if (i == row.size() - 1) continue;
                    msg.append("\t");
                }
                msg.append("\n");
            }
            if (isLargerThanMaxResult) {
                msg.append("\n");
                msg.append(ResultMessages.getExceedsLimitRowsMessage((int)maxResult, (String)"zeppelin.spark.maxResult"));
            }
            msg.append("\n%text ");
            return msg.toString();
        }
        return obj.toString();
    }

    private List sparkRowToList(Row row) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < row.size(); ++i) {
            list.add(row.get(i));
        }
        return list;
    }

    public Dataset<Row> getAsDataFrame(String value) {
        String[] lines = value.split("\\n");
        String head = lines[0];
        String[] columns = head.split("\t");
        StructType schema = new StructType();
        for (String column : columns) {
            schema = schema.add(column, "String");
        }
        ArrayList<GenericRow> rows = new ArrayList<GenericRow>();
        for (int i = 1; i < lines.length; ++i) {
            Object[] tokens = lines[i].split("\t");
            GenericRow row = new GenericRow(tokens);
            rows.add(row);
        }
        return this.sparkSession.createDataFrame(rows, schema);
    }
}

