/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.spark.SparkVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparkShims {
    private static final String HADOOP_VERSION_2_6_6 = "2.6.6";
    private static final String HADOOP_VERSION_2_7_0 = "2.7.0";
    private static final String HADOOP_VERSION_2_7_4 = "2.7.4";
    private static final String HADOOP_VERSION_2_8_0 = "2.8.0";
    private static final String HADOOP_VERSION_2_8_2 = "2.8.2";
    private static final String HADOOP_VERSION_2_9_0 = "2.9.0";
    private static final String HADOOP_VERSION_3_0_0 = "3.0.0";
    private static final String HADOOP_VERSION_3_0_0_ALPHA4 = "3.0.0-alpha4";
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkShims.class);
    private static SparkShims sparkShims;
    protected Properties properties;

    public SparkShims(Properties properties) {
        this.properties = properties;
    }

    private static SparkShims loadShims(int sparkMajorVersion, Properties properties, Object entryPoint) throws Exception {
        Class<?> sparkShimsClass;
        if (sparkMajorVersion == 3) {
            LOGGER.info("Initializing shims for Spark 3.x");
            sparkShimsClass = Class.forName("org.apache.zeppelin.spark.Spark3Shims");
        } else if (sparkMajorVersion == 2) {
            LOGGER.info("Initializing shims for Spark 2.x");
            sparkShimsClass = Class.forName("org.apache.zeppelin.spark.Spark2Shims");
        } else if (sparkMajorVersion == 1) {
            LOGGER.info("Initializing shims for Spark 1.x");
            sparkShimsClass = Class.forName("org.apache.zeppelin.spark.Spark1Shims");
        } else {
            throw new Exception("Spark major version: '" + sparkMajorVersion + "' is not supported yet");
        }
        Constructor<?> c = sparkShimsClass.getConstructor(Properties.class, Object.class);
        return (SparkShims)c.newInstance(properties, entryPoint);
    }

    public static SparkShims getInstance(String sparkVersion, Properties properties, Object entryPoint) throws Exception {
        if (sparkShims == null) {
            int sparkMajorVersion = SparkVersion.fromVersionString(sparkVersion).getMajorVersion();
            sparkShims = SparkShims.loadShims(sparkMajorVersion, properties, entryPoint);
        }
        return sparkShims;
    }

    public abstract void setupSparkListener(String var1, String var2, InterpreterContext var3);

    public abstract String showDataFrame(Object var1, int var2, InterpreterContext var3);

    public abstract Object getAsDataFrame(String var1);

    protected void buildSparkJobUrl(String master, String sparkWebUrl, int jobId, Properties jobProperties, InterpreterContext context) {
        String jobUrl = sparkWebUrl + "/jobs/job?id=" + jobId;
        String version = VersionInfo.getVersion();
        if (master.toLowerCase().contains("yarn") && !this.supportYarn6615(version)) {
            jobUrl = sparkWebUrl + "/jobs";
        }
        String jobGroupId = jobProperties.getProperty("spark.jobGroup.id");
        HashMap<String, String> infos = new HashMap<String, String>();
        infos.put("jobUrl", jobUrl);
        infos.put("label", "SPARK JOB");
        infos.put("tooltip", "View in Spark web UI");
        infos.put("noteId", SparkShims.getNoteId(jobGroupId));
        infos.put("paraId", SparkShims.getParagraphId(jobGroupId));
        LOGGER.debug("Send spark job url: " + infos);
        context.getIntpEventClient().onParaInfosReceived(infos);
    }

    public static String getNoteId(String jobGroupId) {
        String[] tokens = jobGroupId.split("\\|");
        if (tokens.length != 4) {
            throw new RuntimeException("Invalid jobGroupId: " + jobGroupId);
        }
        return tokens[2];
    }

    public static String getParagraphId(String jobGroupId) {
        String[] tokens = jobGroupId.split("\\|");
        if (tokens.length != 4) {
            throw new RuntimeException("Invalid jobGroupId: " + jobGroupId);
        }
        return tokens[3];
    }

    protected boolean supportYarn6615(String version) {
        return VersionUtil.compareVersions((String)HADOOP_VERSION_2_6_6, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_7_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_7_4, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_8_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_8_2, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_9_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_9_0, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0_ALPHA4, (String)version) <= 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0, (String)version) <= 0;
    }

    @VisibleForTesting
    public static void reset() {
        sparkShims = null;
    }
}

