/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.apache.zeppelin.interpreter.BaseZeppelinContext;
import org.apache.zeppelin.interpreter.remote.RemoteEventClientWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparkShims {
    private static final String HADOOP_VERSION_2_6_6 = "2.6.6";
    private static final String HADOOP_VERSION_2_7_0 = "2.7.0";
    private static final String HADOOP_VERSION_2_7_4 = "2.7.4";
    private static final String HADOOP_VERSION_2_8_0 = "2.8.0";
    private static final String HADOOP_VERSION_2_8_2 = "2.8.2";
    private static final String HADOOP_VERSION_2_9_0 = "2.9.0";
    private static final String HADOOP_VERSION_3_0_0 = "3.0.0";
    private static final String HADOOP_VERSION_3_0_0_ALPHA4 = "3.0.0-alpha4";
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkShims.class);
    private static SparkShims sparkShims;

    private static SparkShims loadShims(String sparkVersion) throws ReflectiveOperationException {
        Class<?> sparkShimsClass;
        if ("2".equals(sparkVersion)) {
            LOGGER.info("Initializing shims for Spark 2.x");
            sparkShimsClass = Class.forName("org.apache.zeppelin.spark.Spark2Shims");
        } else {
            LOGGER.info("Initializing shims for Spark 1.x");
            sparkShimsClass = Class.forName("org.apache.zeppelin.spark.Spark1Shims");
        }
        Constructor<?> c = sparkShimsClass.getConstructor(new Class[0]);
        return (SparkShims)c.newInstance(new Object[0]);
    }

    public static SparkShims getInstance(String sparkVersion) {
        if (sparkShims == null) {
            String sparkMajorVersion = SparkShims.getSparkMajorVersion(sparkVersion);
            try {
                sparkShims = SparkShims.loadShims(sparkMajorVersion);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return sparkShims;
    }

    private static String getSparkMajorVersion(String sparkVersion) {
        return sparkVersion.startsWith("2") ? "2" : "1";
    }

    public abstract void setupSparkListener(String var1, String var2);

    protected String getNoteId(String jobgroupId) {
        int indexOf = jobgroupId.indexOf("-");
        int secondIndex = jobgroupId.indexOf("-", indexOf + 1);
        return jobgroupId.substring(indexOf + 1, secondIndex);
    }

    protected String getParagraphId(String jobgroupId) {
        int indexOf = jobgroupId.indexOf("-");
        int secondIndex = jobgroupId.indexOf("-", indexOf + 1);
        return jobgroupId.substring(secondIndex + 1, jobgroupId.length());
    }

    protected void buildSparkJobUrl(String master, String sparkWebUrl, int jobId, Properties jobProperties) {
        boolean showSparkUI;
        String jobGroupId = jobProperties.getProperty("spark.jobGroup.id");
        String uiEnabled = jobProperties.getProperty("spark.ui.enabled");
        String jobUrl = sparkWebUrl + "/jobs/job?id=" + jobId;
        String version = VersionInfo.getVersion();
        if (master.toLowerCase().contains("yarn") && !this.supportYarn6615(version)) {
            jobUrl = sparkWebUrl + "/jobs";
        }
        String noteId = this.getNoteId(jobGroupId);
        String paragraphId = this.getParagraphId(jobGroupId);
        boolean bl = showSparkUI = uiEnabled == null || !uiEnabled.trim().toLowerCase().equals("false");
        if (showSparkUI) {
            RemoteEventClientWrapper eventClient = BaseZeppelinContext.getEventClient();
            HashMap<String, String> infos = new HashMap<String, String>();
            infos.put("jobUrl", jobUrl);
            infos.put("label", "SPARK JOB");
            infos.put("tooltip", "View in Spark web UI");
            if (eventClient != null) {
                eventClient.onParaInfosReceived(noteId, paragraphId, infos);
            }
        }
    }

    protected boolean supportYarn6615(String version) {
        return VersionUtil.compareVersions((String)HADOOP_VERSION_2_6_6, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_7_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_7_4, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_8_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_8_2, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_9_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_9_0, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0_ALPHA4, (String)version) <= 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0, (String)version) <= 0;
    }
}

