/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.spark.SparkContext;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.util.SqlSplitter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSqlInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkSqlInterpreter.class);
    private SparkInterpreter sparkInterpreter;
    private SqlSplitter sqlSplitter;

    public SparkSqlInterpreter(Properties property) {
        super(property);
    }

    public void open() throws InterpreterException {
        this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
        this.sqlSplitter = new SqlSplitter();
    }

    public boolean concurrentSQL() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.concurrentSQL"));
    }

    public void close() {
    }

    protected boolean isInterpolate() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.sql.interpolation", "false"));
    }

    public ZeppelinContext getZeppelinContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        if (this.sparkInterpreter.isUnsupportedSparkVersion()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Spark " + this.sparkInterpreter.getSparkVersion().toString() + " is not supported");
        }
        Utils.printDeprecateMessage(this.sparkInterpreter.getSparkVersion(), context, this.properties);
        this.sparkInterpreter.getZeppelinContext().setInterpreterContext(context);
        Object sqlContext = this.sparkInterpreter.getSQLContext();
        SparkContext sc = this.sparkInterpreter.getSparkContext();
        StringBuilder builder = new StringBuilder();
        List sqls = this.sqlSplitter.splitSql(st);
        int maxResult = Integer.parseInt(context.getLocalProperties().getOrDefault("limit", "" + this.sparkInterpreter.getZeppelinContext().getMaxResult()));
        sc.setLocalProperty("spark.scheduler.pool", (String)context.getLocalProperties().get("pool"));
        sc.setJobGroup(Utils.buildJobGroupId(context), Utils.buildJobDesc(context), false);
        String curSql = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (!this.sparkInterpreter.isScala212()) {
                Thread.currentThread().setContextClassLoader(this.sparkInterpreter.getScalaShellClassLoader());
            }
            Method method = sqlContext.getClass().getMethod("sql", String.class);
            Iterator iterator = sqls.iterator();
            while (iterator.hasNext()) {
                String sql;
                curSql = sql = (String)iterator.next();
                String result = this.sparkInterpreter.getZeppelinContext().showData(method.invoke(sqlContext, sql), maxResult);
                builder.append(result);
            }
        }
        catch (Exception e) {
            builder.append("\n%text Error happens in sql: " + curSql + "\n");
            if (Boolean.parseBoolean(this.getProperty("zeppelin.spark.sql.stacktrace", "false"))) {
                builder.append(ExceptionUtils.getStackTrace((Throwable)e));
            } else {
                LOGGER.error("Invocation target exception", (Throwable)e);
                String msg = e.getMessage() + "\nset zeppelin.spark.sql.stacktrace = true to see full stacktrace";
                builder.append(msg);
            }
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, builder.toString());
            return interpreterResult;
        }
        finally {
            sc.clearJobGroup();
            if (!this.sparkInterpreter.isScala212()) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, builder.toString());
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        SparkContext sc = this.sparkInterpreter.getSparkContext();
        sc.cancelJobGroup(Utils.buildJobGroupId(context));
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.sparkInterpreter.getProgress(context);
    }

    public Scheduler getScheduler() {
        if (this.concurrentSQL()) {
            int maxConcurrency = Integer.parseInt(this.getProperty("zeppelin.spark.concurrentSQL.max", "10"));
            return SchedulerFactory.singleton().createOrGetParallelScheduler(SparkSqlInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), maxConcurrency);
        }
        try {
            return ((SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class, false))).getScheduler();
        }
        catch (InterpreterException e) {
            throw new RuntimeException("Fail to getScheduler", e);
        }
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }
}

