/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.r.RInterpreter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.apache.zeppelin.spark.ZeppelinRContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRInterpreter
extends RInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkRInterpreter.class);
    private SparkInterpreter sparkInterpreter;
    private SparkVersion sparkVersion;
    private boolean isSpark1;
    private SparkContext sc;
    private JavaSparkContext jsc;

    public SparkRInterpreter(Properties property) {
        super(property);
    }

    protected boolean isSparkSupported() {
        return true;
    }

    protected boolean isSecretSupported() {
        return this.sparkVersion.isSecretSocketSupported();
    }

    protected int sparkVersion() {
        return new SparkVersion(this.sc.version()).toNumber();
    }

    public void open() throws InterpreterException {
        this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
        this.sc = this.sparkInterpreter.getSparkContext();
        this.jsc = this.sparkInterpreter.getJavaSparkContext();
        this.sparkVersion = new SparkVersion(this.sc.version());
        this.isSpark1 = this.sparkVersion.getMajorVersion() == 1;
        LOGGER.info("SparkRInterpreter: SPARK_HOME={}", (Object)this.sc.getConf().getenv("SPARK_HOME"));
        Arrays.stream(this.sc.getConf().getAll()).forEach(x -> LOGGER.info("SparkRInterpreter: conf, {}={}", x._1, x._2));
        this.properties.entrySet().stream().forEach(x -> LOGGER.info("SparkRInterpreter: prop, {}={}", x.getKey(), x.getValue()));
        ZeppelinRContext.setSparkContext(this.sc);
        ZeppelinRContext.setJavaSparkContext(this.jsc);
        if (!this.isSpark1) {
            ZeppelinRContext.setSparkSession(this.sparkInterpreter.getSparkSession());
        }
        ZeppelinRContext.setSqlContext(this.sparkInterpreter.getSQLContext());
        ZeppelinRContext.setZeppelinContext(this.sparkInterpreter.getZeppelinContext());
        super.open();
    }

    public InterpreterResult internalInterpret(String lines, InterpreterContext interpreterContext) throws InterpreterException {
        Utils.printDeprecateMessage(this.sparkInterpreter.getSparkVersion(), interpreterContext, this.properties);
        String jobGroup = Utils.buildJobGroupId(interpreterContext);
        String jobDesc = Utils.buildJobDesc(interpreterContext);
        this.sparkInterpreter.getSparkContext().setJobGroup(jobGroup, jobDesc, false);
        String setJobGroup = "";
        setJobGroup = !this.isSpark1 ? "dummy__ <- setJobGroup(\"" + jobGroup + "\", \" +" + jobDesc + "\", TRUE)" : "dummy__ <- setJobGroup(sc, \"" + jobGroup + "\", \"" + jobDesc + "\", TRUE)";
        lines = setJobGroup + "\n" + lines;
        if (this.sparkInterpreter.getSparkVersion().newerThanEquals(SparkVersion.SPARK_2_3_0)) {
            String setPoolStmt = "setLocalProperty('spark.scheduler.pool', NULL)";
            if (interpreterContext.getLocalProperties().containsKey("pool")) {
                setPoolStmt = "setLocalProperty('spark.scheduler.pool', '" + (String)interpreterContext.getLocalProperties().get("pool") + "')";
            }
            lines = setPoolStmt + "\n" + lines;
        }
        return super.internalInterpret(lines, interpreterContext);
    }

    public void close() throws InterpreterException {
        super.close();
        if (this.sparkInterpreter != null) {
            this.sparkInterpreter.close();
            this.sparkInterpreter = null;
        }
    }

    public void cancel(InterpreterContext context) {
        if (this.sc != null) {
            this.sc.cancelJobGroup(Utils.buildJobGroupId(context));
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getProgress(context);
        }
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(SparkRInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public ZeppelinContext getZeppelinContext() {
        return this.sparkInterpreter.getZeppelinContext();
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return new ArrayList<InterpreterCompletion>();
    }

    public boolean isSpark1() {
        return this.isSpark1;
    }
}

