/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.spark.IPySparkInterpreter;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PySparkInterpreter
extends PythonInterpreter {
    private static Logger LOGGER = LoggerFactory.getLogger(PySparkInterpreter.class);
    private SparkInterpreter sparkInterpreter;

    public PySparkInterpreter(Properties property) {
        super(property);
        this.useBuiltinPy4j = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InterpreterException {
        File[] files;
        File localRepoDir;
        this.setProperty("zeppelin.python.useIPython", this.getProperty("zeppelin.pyspark.useIPython", "true"));
        URL[] urls = new URL[]{};
        LinkedList<URL> urlList = new LinkedList<URL>();
        String localRepo = this.getProperty("zeppelin.interpreter.localRepo");
        if (localRepo != null && (localRepoDir = new File(localRepo)).exists() && (files = localRepoDir.listFiles()) != null) {
            for (File f : files) {
                try {
                    urlList.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Error", (Throwable)e);
                }
            }
        }
        urls = urlList.toArray(urls);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader newCl = new URLClassLoader(urls, oldCl);
            Thread.currentThread().setContextClassLoader(newCl);
            this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
            this.setProperty("zeppelin.py4j.useAuth", this.sparkInterpreter.getSparkVersion().isSecretSocketSupported() + "");
            super.open();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        if (!this.useIPython()) {
            try {
                this.bootstrapInterpreter("python/zeppelin_pyspark.py");
            }
            catch (IOException e) {
                LOGGER.error("Fail to bootstrap pyspark", (Throwable)e);
                throw new InterpreterException("Fail to bootstrap pyspark", (Throwable)e);
            }
        }
    }

    public void close() throws InterpreterException {
        super.close();
        if (this.sparkInterpreter != null) {
            this.sparkInterpreter.close();
        }
    }

    protected IPythonInterpreter getIPythonInterpreter() throws InterpreterException {
        return (IPythonInterpreter)this.getInterpreterInTheSameSessionByClassName(IPySparkInterpreter.class, false);
    }

    protected ZeppelinContext createZeppelinContext() {
        return this.sparkInterpreter.getZeppelinContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        PrintStream originalStdout = System.out;
        PrintStream originalStderr = System.err;
        try {
            System.setOut(new PrintStream((OutputStream)context.out));
            System.setErr(new PrintStream((OutputStream)context.out));
            Utils.printDeprecateMessage(this.sparkInterpreter.getSparkVersion(), context, this.properties);
            InterpreterResult interpreterResult = super.interpret(st, context);
            return interpreterResult;
        }
        finally {
            System.setOut(originalStdout);
            System.setErr(originalStderr);
        }
    }

    protected void preCallPython(InterpreterContext context) {
        String jobGroup = Utils.buildJobGroupId(context);
        String jobDesc = Utils.buildJobDesc(context);
        this.callPython(new PythonInterpreter.PythonInterpretRequest((PythonInterpreter)this, String.format("if 'sc' in locals():\n\tsc.setJobGroup('%s', '%s')", jobGroup, jobDesc), false, false));
        String pool = "None";
        if (context.getLocalProperties().containsKey("pool")) {
            pool = "'" + (String)context.getLocalProperties().get("pool") + "'";
        }
        String setPoolStmt = "if 'sc' in locals():\n\tsc.setLocalProperty('spark.scheduler.pool', " + pool + ")";
        this.callPython(new PythonInterpreter.PythonInterpretRequest((PythonInterpreter)this, setPoolStmt, false, false));
    }

    protected String getPythonExec() {
        if (!StringUtils.isBlank((CharSequence)this.getProperty("spark.pyspark.driver.python", ""))) {
            return this.properties.getProperty("spark.pyspark.driver.python");
        }
        if (!StringUtils.isBlank((CharSequence)this.getProperty("spark.pyspark.python", ""))) {
            return this.properties.getProperty("spark.pyspark.python");
        }
        if (System.getenv("PYSPARK_PYTHON") != null) {
            return System.getenv("PYSPARK_PYTHON");
        }
        if (System.getenv("PYSPARK_DRIVER_PYTHON") != null) {
            return System.getenv("PYSPARK_DRIVER_PYTHON");
        }
        return "python";
    }

    public ZeppelinContext getZeppelinContext() {
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getZeppelinContext();
        }
        return null;
    }

    public JavaSparkContext getJavaSparkContext() {
        if (this.sparkInterpreter == null) {
            return null;
        }
        return new JavaSparkContext(this.sparkInterpreter.getSparkContext());
    }

    public Object getSparkSession() {
        if (this.sparkInterpreter == null) {
            return null;
        }
        return this.sparkInterpreter.getSparkSession();
    }

    public SparkConf getSparkConf() {
        JavaSparkContext sc = this.getJavaSparkContext();
        if (sc == null) {
            return null;
        }
        return sc.getConf();
    }

    public Object getSQLContext() {
        if (this.sparkInterpreter == null) {
            return null;
        }
        return this.sparkInterpreter.getSQLContext();
    }

    public boolean isSpark1() {
        return this.sparkInterpreter.getSparkVersion().getMajorVersion() == 1;
    }

    public boolean isSpark3() {
        return this.sparkInterpreter.getSparkVersion().getMajorVersion() == 3;
    }
}

