/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.kotlin.KotlinInterpreter;
import org.apache.zeppelin.kotlin.context.KotlinReceiver;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.apache.zeppelin.spark.kotlin.SparkKotlinReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Console;

public class KotlinSparkInterpreter
extends Interpreter {
    private static Logger logger = LoggerFactory.getLogger(KotlinSparkInterpreter.class);
    private static final SparkVersion KOTLIN_SPARK_SUPPORTED_VERSION = SparkVersion.SPARK_2_4_0;
    private InterpreterResult unsupportedMessage;
    private KotlinInterpreter interpreter;
    private SparkInterpreter sparkInterpreter;
    private ZeppelinContext z;
    private JavaSparkContext jsc;

    public KotlinSparkInterpreter(Properties properties) {
        super(properties);
        logger.debug("Creating KotlinSparkInterpreter");
        this.interpreter = new KotlinInterpreter(properties);
    }

    public void open() throws InterpreterException {
        this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
        this.jsc = this.sparkInterpreter.getJavaSparkContext();
        SparkVersion sparkVersion = SparkVersion.fromVersionString((String)this.jsc.version());
        if (sparkVersion.olderThan(KOTLIN_SPARK_SUPPORTED_VERSION)) {
            this.unsupportedMessage = new InterpreterResult(InterpreterResult.Code.ERROR, "Spark version is " + sparkVersion + ", only " + KOTLIN_SPARK_SUPPORTED_VERSION + " and newer are supported");
        }
        this.z = this.sparkInterpreter.getZeppelinContext();
        SparkKotlinReceiver ctx = new SparkKotlinReceiver(this.sparkInterpreter.getSparkSession(), this.jsc, (SQLContext)this.sparkInterpreter.getSQLContext(), this.z);
        List<String> classpath = KotlinSparkInterpreter.sparkClasspath();
        String outputDir = null;
        SparkConf conf = this.jsc.getConf();
        if (conf != null) {
            outputDir = (String)conf.getOption("spark.repl.class.outputDir").getOrElse(null);
        }
        this.interpreter.getKotlinReplProperties().receiver((KotlinReceiver)ctx).classPath(classpath).outputDir(outputDir).codeOnLoad("import org.apache.zeppelin.display.ui.OptionInput.ParamOption\nimport org.apache.zeppelin.interpreter.ZeppelinContext\n\nfun ZeppelinContext.select(name: String, defaultValue: Any?, options: List<Pair<Any?, String>>): Any? {\n    return select(name, defaultValue, options.map{ ParamOption(it.first, it.second) }.toTypedArray())\n}\n\nfun ZeppelinContext.select(name: String, options: List<Pair<Any?, String>>): Any? {\n    return select(name, \"\", options)\n}").codeOnLoad("import org.apache.spark.sql.types.DataTypes\nimport org.apache.spark.sql.functions.*\nimport org.apache.spark.sql.expressions.UserDefinedFunction\nimport org.apache.spark.sql.api.java.*").codeOnLoad("import org.apache.spark.sql.SparkSession\nval spark = _sparkObject as SparkSession");
        this.interpreter.open();
    }

    public void close() throws InterpreterException {
        this.interpreter.close();
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        if (this.isSparkVersionUnsupported()) {
            return this.unsupportedMessage;
        }
        this.z.setInterpreterContext(context);
        this.z.setGui(context.getGui());
        this.z.setNoteGui(context.getNoteGui());
        InterpreterContext.set((InterpreterContext)context);
        this.jsc.setJobGroup(Utils.buildJobGroupId(context), Utils.buildJobDesc(context), false);
        this.jsc.setLocalProperty("spark.scheduler.pool", (String)context.getLocalProperties().get("pool"));
        InterpreterOutput out = context.out;
        PrintStream scalaOut = Console.out();
        PrintStream newOut = out != null ? new PrintStream((OutputStream)out) : null;
        Console.setOut((PrintStream)newOut);
        InterpreterResult result = this.interpreter.interpret(st, context);
        Console.setOut((PrintStream)scalaOut);
        return result;
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        if (this.isSparkVersionUnsupported()) {
            return;
        }
        this.jsc.cancelJobGroup(Utils.buildJobGroupId(context));
        this.interpreter.cancel(context);
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return this.interpreter.getFormType();
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        if (this.isSparkVersionUnsupported()) {
            return 0;
        }
        return this.sparkInterpreter.getProgress(context);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        if (this.isSparkVersionUnsupported()) {
            return Collections.emptyList();
        }
        return this.interpreter.completion(buf, cursor, interpreterContext);
    }

    boolean isSparkVersionUnsupported() {
        return this.unsupportedMessage != null;
    }

    private static List<String> sparkClasspath() {
        String sparkJars = System.getProperty("spark.jars");
        Pattern isKotlinJar = Pattern.compile("/kotlin-[a-z]*(-.*)?\\.jar");
        Stream<File> addedJars = Arrays.stream(org.apache.spark.util.Utils.resolveURIs((String)sparkJars).split(",")).filter(s -> !s.trim().equals("")).filter(s -> !isKotlinJar.matcher((CharSequence)s).find()).map(s -> {
            int p = s.indexOf(58);
            return new File(s.substring(p + 1));
        });
        Stream<File> systemJars = Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(File::new);
        return Stream.concat(addedJars, systemJars).map(file -> {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return "";
            }
        }).collect(Collectors.toList());
    }
}

